% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landfireAPI.R
\name{landfireAPIv2}
\alias{landfireAPIv2}
\title{Call the LANDFIRE Product Service (LFPS) API}
\usage{
landfireAPIv2(
  products,
  aoi,
  email,
  projection = NULL,
  resolution = NULL,
  edit_rule = NULL,
  edit_mask = NULL,
  priority_code = NULL,
  path = NULL,
  max_time = 10000,
  method = "curl",
  verbose = TRUE,
  background = FALSE,
  execute = TRUE
)
}
\arguments{
\item{products}{Product names as character vector
(see: \href{https://lfps.usgs.gov/products}{Products Table})}

\item{aoi}{Area of interest as character or numeric vector defined by
latitude and longitude in decimal degrees in WGS84 and ordered
\code{xmin}, \code{ymin}, \code{xmax}, \code{ymax} or a LANDFIRE map zone.}

\item{email}{Email address as character string. This is a required argument
for the LFPS v2 API. See the \href{https://lfps.usgs.gov/LFProductsServiceUserGuide.pdf}{LFPS Guide}
for more information. Outside of the LFPS API request, this email address
is not used for any other purpose, stored, or shared by \code{rlandfire}.}

\item{projection}{Optional. A numeric value of the WKID for the output projection
Default is a localized Albers projection.}

\item{resolution}{Optional. A numeric value between 30-9999 specifying the
resample resolution in meters. Default is 30m.}

\item{edit_rule}{Optional. A list of character vectors ordered "operator class"
"product", "operator", "value" where "operator class" is one of "condition",
"ORcondition", or "change". Edits are limited to fuel theme products only.
(see: \href{https://lfps.usgs.gov/LFProductsServiceUserGuide.pdf}{LFPS Guide})}

\item{edit_mask}{Optional. Path to a compressed shapefile (.zip) to be used
as an edit mask. The shapefile must be less than 1MB in size and must
comply with ESRI shapefile naming rules.}

\item{priority_code}{Optional. Priority code for wildland fire systems/users.
Contact the LANDFIRE help desk for information (\href{mailto:helpdesk@landfire.gov}{helpdesk@landfire.gov})}

\item{path}{Path to \code{.zip} directory. Passed to \code{\link[utils:download.file]{utils::download.file()}}.
If NULL, a temporary directory is created.}

\item{max_time}{Maximum time, in seconds, to wait for job to be completed.}

\item{method}{Passed to \code{\link[utils:download.file]{utils::download.file()}}. See \code{?download.file}}

\item{verbose}{If FALSE suppress all status messages}

\item{background}{If TRUE, the function will return immediately and the job
will run in the background. User will need to check the status of the job
manually with \code{checkStatus()}.}

\item{execute}{If FALSE, the function will build a request without submitting
it to the LFPS API.}
}
\value{
Returns a \code{landfire_api} object with named elements:
\itemize{
\item \code{request} - list with elements \code{query}, \code{date}, \code{url}, \code{job_id}, \code{request},\code{dwl_url}
\item \code{content} - Informative messages passed from API
\item \code{response} - Full response
\item \code{status} - Final API status, one of "Failed", "Succeeded", or "Timed out"
\item \code{time} - time of job completion
\item \code{path} - path to save directory
}
}
\description{
\code{landfireAPIv2} downloads LANDFIRE data by calling the LFPS API
}
\examples{
\dontrun{
products <-  c("ASP2020", "ELEV2020", "230CC")
aoi <- c("-123.7835", "41.7534", "-123.6352", "41.8042")
email <- "email@example.com"
projection <- 6414
resolution <- 90
edit_rule <- list(c("condition","ELEV2020","lt",500),
                  c("change", "230CC", "st", 181))
save_file <- tempfile(fileext = ".zip")
resp <- landfireAPIv2(products, aoi, email, projection,
                      resolution, edit_rule = edit_rule,
                      path = save_file)
}
}
