% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x13_spec.R
\name{x13_spec}
\alias{x13_spec}
\alias{regarima_spec}
\alias{x11_spec}
\title{RegARIMA/X-13 Default Specifications}
\usage{
regarima_spec(name = c("rg4", "rg0", "rg1", "rg2c", "rg3", "rg5c"))

x13_spec(name = c("rsa4", "rsa0", "rsa1", "rsa2c", "rsa3", "rsa5c"))

x11_spec()
}
\arguments{
\item{name}{the name of a predefined specification.}
}
\value{
an object of class \code{"JD3_X13_SPEC"} (\code{x13_spec()}),
\code{"JD3_REGARIMA_SPEC"} (\code{regarima_spec()}) or
\code{"JD3_X11_SPEC"} (\code{x11_spec()}).
}
\description{
Set of functions to create default specification objects associated with the
X-13ARIMA seasonal adjustment method.

Specification setting of sheer X-11 decomposition method (without reg-arima
pre-adjustment) is supported by the \code{x11_spec()} function only and doesn't
appear among the possible X13-Arima default specifications.

Specification setting can be restricted to the reg-arima part with the
\code{regarima_spec()} function, without argument \code{regarima_spec()} yields a RG5c
specification.

When setting a complete X13-Arima spec, \code{x13_spec()} without argument yields
a RSA5c specification.
}
\details{
The available predefined 'JDemetra+' model specifications are described in the table below:

\tabular{rrrrrrr}{
\strong{Identifier} |\tab \strong{Log/level detection} |\tab \strong{Outliers detection} |\tab \strong{Calendar effects} |\tab \strong{ARIMA}\cr
RSA0/RG0 |\tab \emph{NA} |\tab \emph{NA} |\tab \emph{NA} |\tab Airline(+mean)\cr
RSA1/RG1 |\tab automatic |\tab AO/LS/TC  |\tab \emph{NA} |\tab Airline(+mean)\cr
RSA2c/RG2c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab Airline(+mean)\cr
RSA3/RG3 |\tab automatic |\tab AO/LS/TC |\tab \emph{NA} |\tab automatic\cr
RSA4c/RG4c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab automatic\cr
RSA5c/RG5c |\tab automatic |\tab AO/LS/TC |\tab 7 td vars + Easter |\tab automatic
}
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
init_spec <- x11_spec()
init_spec
init_spec <- regarima_spec("rg4")
init_spec
init_spec <- x13_spec("rsa5c")
init_spec
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item To set the pre-processing parameters:
\code{\link[rjd3toolkit:set_arima]{rjd3toolkit::set_arima()}}, \code{\link[rjd3toolkit:set_automodel]{rjd3toolkit::set_automodel()}},
\code{\link[rjd3toolkit:set_basic]{rjd3toolkit::set_basic()}}, \code{\link[rjd3toolkit:set_easter]{rjd3toolkit::set_easter()}},
\code{\link[rjd3toolkit:set_estimate]{rjd3toolkit::set_estimate()}}, \code{\link[rjd3toolkit:set_outlier]{rjd3toolkit::set_outlier()}},
\code{\link[rjd3toolkit:set_tradingdays]{rjd3toolkit::set_tradingdays()}}, \code{\link[rjd3toolkit:set_transform]{rjd3toolkit::set_transform()}},
\code{\link[rjd3toolkit:add_outlier]{rjd3toolkit::add_outlier()}}, \code{\link[rjd3toolkit:add_outlier]{rjd3toolkit::remove_outlier()}},
\code{\link[rjd3toolkit:add_outlier]{rjd3toolkit::add_ramp()}}, \code{\link[rjd3toolkit:add_outlier]{rjd3toolkit::remove_ramp()}},
\code{\link[rjd3toolkit:add_usrdefvar]{rjd3toolkit::add_usrdefvar()}}.
\item To set the decomposition parameters: \code{\link[=set_x11]{set_x11()}}.
\item To set the benchmarking parameters: \code{\link[rjd3toolkit:set_benchmarking]{rjd3toolkit::set_benchmarking()}}.
}
}
