/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.processing.GenericResults;
import jdplus.toolkit.base.api.processing.ProcResults;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.x13.base.api.regarima.RegArimaException;
import jdplus.x13.base.api.regarima.RegArimaLoader;
import jdplus.x13.base.api.regarima.RegArimaSpec;
import lombok.Generated;

public final class RegArima {
    private static final RegArimaLoader.Processor ENGINE = new RegArimaLoader.Processor();
    private static final AtomicReference<Processor> LEGACYENGINE = new AtomicReference();

    public static void setEngine(Processor algorithm) {
        ENGINE.set(algorithm);
    }

    public static Processor getEngine() {
        return ENGINE.get();
    }

    public static ProcResults process(TsData series, RegArimaSpec spec, ModellingContext context, List<String> items) {
        return ENGINE.get().process(series, spec, context, items);
    }

    public static void setLegacyEngine(Processor algorithm) {
        LEGACYENGINE.set(algorithm);
    }

    public static Processor getLegacyEngine() {
        return LEGACYENGINE.get();
    }

    public static ProcResults processLegacy(TsData series, RegArimaSpec spec, ModellingContext context, List<String> items) {
        Processor cp = LEGACYENGINE.get();
        if (cp == null) {
            throw new RegArimaException("No legacy engine");
        }
        return cp.process(series, spec, context, items);
    }

    @Generated
    private RegArima() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor {
        public ProcResults process(TsData var1, RegArimaSpec var2, ModellingContext var3, List<String> var4);
    }

    public static final class DefProcessor
    implements Processor {
        @Override
        public ProcResults process(TsData series, RegArimaSpec spec, ModellingContext context, List<String> items) {
            return GenericResults.notImplemented();
        }
    }
}

