/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.tramoseats.base.api.tramo.AutoModelSpec;
import jdplus.tramoseats.base.api.tramo.CalendarSpec;
import jdplus.tramoseats.base.api.tramo.EasterSpec;
import jdplus.tramoseats.base.api.tramo.EstimateSpec;
import jdplus.tramoseats.base.api.tramo.MeanSpec;
import jdplus.tramoseats.base.api.tramo.OutlierSpec;
import jdplus.tramoseats.base.api.tramo.RegressionSpec;
import jdplus.tramoseats.base.api.tramo.RegressionTestType;
import jdplus.tramoseats.base.api.tramo.TradingDaysSpec;
import jdplus.tramoseats.base.api.tramo.TramoException;
import jdplus.tramoseats.base.api.tramo.TransformSpec;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TramoSpec
implements Validatable<TramoSpec>,
ProcSpecification {
    public static final String METHOD = "tramo";
    public static final String FAMILY = "Modelling";
    public static final String VERSION_LEGACY = "0.1.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR_LEGACY = new AlgorithmDescriptor("Modelling", "tramo", "0.1.0.0");
    public static final String VERSION_V3 = "3.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR_V3 = new AlgorithmDescriptor("Modelling", "tramo", "3.0.0");
    public static final TramoSpec DEFAULT;
    @NonNull
    private final SarimaSpec arima;
    @NonNull
    private final TransformSpec transform;
    @NonNull
    private final AutoModelSpec autoModel;
    @NonNull
    private final EstimateSpec estimate;
    @NonNull
    private final OutlierSpec outliers;
    @NonNull
    private final RegressionSpec regression;
    public static final TramoSpec TR0;
    public static final TramoSpec TR1;
    public static final TramoSpec TR2;
    public static final TramoSpec TR3;
    public static final TramoSpec TR4;
    public static final TramoSpec TR5;
    public static final TramoSpec TRfull;
    private static final String SMETHOD = "TR";

    public static Builder builder() {
        return new Builder().transform(TransformSpec.DEFAULT_UNUSED).estimate(EstimateSpec.DEFAULT).autoModel(AutoModelSpec.DEFAULT_DISABLED).outliers(OutlierSpec.DEFAULT_DISABLED).arima(SarimaSpec.airline()).regression(RegressionSpec.DEFAULT_CONST);
    }

    public TramoSpec validate() throws IllegalArgumentException {
        this.autoModel.validate();
        this.estimate.validate();
        this.outliers.validate();
        this.regression.validate();
        this.transform.validate();
        return this;
    }

    public AlgorithmDescriptor getAlgorithmDescriptor() {
        return DESCRIPTOR_V3;
    }

    public boolean isUsingAutoModel() {
        return this.autoModel.isEnabled();
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public static final TramoSpec[] allSpecifications() {
        return new TramoSpec[]{TR0, TR1, TR2, TR3, TR4, TR5, TRfull};
    }

    public static TramoSpec fromString(String name) {
        switch (name) {
            case "TR0": 
            case "tr0": {
                return TR0;
            }
            case "TR1": 
            case "tr1": {
                return TR1;
            }
            case "TR2": 
            case "tr2": {
                return TR2;
            }
            case "TR3": 
            case "tr3": {
                return TR3;
            }
            case "TR4": 
            case "tr4": {
                return TR4;
            }
            case "TR5": 
            case "tr5": {
                return TR5;
            }
            case "TRfull": 
            case "trfull": {
                return TRfull;
            }
        }
        throw new TramoException();
    }

    public String display() {
        if (this == TR0) {
            return "TR0";
        }
        if (this == TR1) {
            return "TR1";
        }
        if (this == TR2) {
            return "TR2";
        }
        if (this == TR3) {
            return "TR3";
        }
        if (this == TR4) {
            return "TR4";
        }
        if (this == TR5) {
            return "TR5";
        }
        if (this == TRfull) {
            return "TRfull";
        }
        if (this.equals(TR0)) {
            return "TR0";
        }
        if (this.equals(TR1)) {
            return "TR1";
        }
        if (this.equals(TR2)) {
            return "TR2";
        }
        if (this.equals(TR3)) {
            return "TR3";
        }
        if (this.equals(TR4)) {
            return "TR4";
        }
        if (this.equals(TR5)) {
            return "TR5";
        }
        if (this.equals(TRfull)) {
            return "TRfull";
        }
        return SMETHOD;
    }

    @Generated
    TramoSpec(@NonNull SarimaSpec arima, @NonNull TransformSpec transform, @NonNull AutoModelSpec autoModel, @NonNull EstimateSpec estimate, @NonNull OutlierSpec outliers, @NonNull RegressionSpec regression) {
        if (arima == null) {
            throw new NullPointerException("arima is marked non-null but is null");
        }
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        if (autoModel == null) {
            throw new NullPointerException("autoModel is marked non-null but is null");
        }
        if (estimate == null) {
            throw new NullPointerException("estimate is marked non-null but is null");
        }
        if (outliers == null) {
            throw new NullPointerException("outliers is marked non-null but is null");
        }
        if (regression == null) {
            throw new NullPointerException("regression is marked non-null but is null");
        }
        this.arima = arima;
        this.transform = transform;
        this.autoModel = autoModel;
        this.estimate = estimate;
        this.outliers = outliers;
        this.regression = regression;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().arima(this.arima).transform(this.transform).autoModel(this.autoModel).estimate(this.estimate).outliers(this.outliers).regression(this.regression);
    }

    @NonNull
    @Generated
    public SarimaSpec getArima() {
        return this.arima;
    }

    @NonNull
    @Generated
    public TransformSpec getTransform() {
        return this.transform;
    }

    @NonNull
    @Generated
    public AutoModelSpec getAutoModel() {
        return this.autoModel;
    }

    @NonNull
    @Generated
    public EstimateSpec getEstimate() {
        return this.estimate;
    }

    @NonNull
    @Generated
    public OutlierSpec getOutliers() {
        return this.outliers;
    }

    @NonNull
    @Generated
    public RegressionSpec getRegression() {
        return this.regression;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TramoSpec)) {
            return false;
        }
        TramoSpec other = (TramoSpec)o;
        SarimaSpec this$arima = this.getArima();
        SarimaSpec other$arima = other.getArima();
        if (this$arima == null ? other$arima != null : !this$arima.equals(other$arima)) {
            return false;
        }
        TransformSpec this$transform = this.getTransform();
        TransformSpec other$transform = other.getTransform();
        if (this$transform == null ? other$transform != null : !((Object)this$transform).equals(other$transform)) {
            return false;
        }
        AutoModelSpec this$autoModel = this.getAutoModel();
        AutoModelSpec other$autoModel = other.getAutoModel();
        if (this$autoModel == null ? other$autoModel != null : !((Object)this$autoModel).equals(other$autoModel)) {
            return false;
        }
        EstimateSpec this$estimate = this.getEstimate();
        EstimateSpec other$estimate = other.getEstimate();
        if (this$estimate == null ? other$estimate != null : !((Object)this$estimate).equals(other$estimate)) {
            return false;
        }
        OutlierSpec this$outliers = this.getOutliers();
        OutlierSpec other$outliers = other.getOutliers();
        if (this$outliers == null ? other$outliers != null : !((Object)this$outliers).equals(other$outliers)) {
            return false;
        }
        RegressionSpec this$regression = this.getRegression();
        RegressionSpec other$regression = other.getRegression();
        return !(this$regression == null ? other$regression != null : !((Object)this$regression).equals(other$regression));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SarimaSpec $arima = this.getArima();
        result = result * 59 + ($arima == null ? 43 : $arima.hashCode());
        TransformSpec $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : ((Object)$transform).hashCode());
        AutoModelSpec $autoModel = this.getAutoModel();
        result = result * 59 + ($autoModel == null ? 43 : ((Object)$autoModel).hashCode());
        EstimateSpec $estimate = this.getEstimate();
        result = result * 59 + ($estimate == null ? 43 : ((Object)$estimate).hashCode());
        OutlierSpec $outliers = this.getOutliers();
        result = result * 59 + ($outliers == null ? 43 : ((Object)$outliers).hashCode());
        RegressionSpec $regression = this.getRegression();
        result = result * 59 + ($regression == null ? 43 : ((Object)$regression).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "TramoSpec(arima=" + String.valueOf(this.getArima()) + ", transform=" + String.valueOf(this.getTransform()) + ", autoModel=" + String.valueOf(this.getAutoModel()) + ", estimate=" + String.valueOf(this.getEstimate()) + ", outliers=" + String.valueOf(this.getOutliers()) + ", regression=" + String.valueOf(this.getRegression()) + ")";
    }

    static {
        TR0 = DEFAULT = (TramoSpec)TramoSpec.builder().build();
        EasterSpec e = (EasterSpec)EasterSpec.builder().type(EasterSpec.Type.Standard).test(true).build();
        TradingDaysSpec wd = TradingDaysSpec.td(TradingDaysType.TD2, LengthOfPeriodType.LeapYear, RegressionTestType.Separate_T, false);
        TradingDaysSpec td = TradingDaysSpec.td(TradingDaysType.TD7, LengthOfPeriodType.LeapYear, RegressionTestType.Separate_T, false);
        TradingDaysSpec dc = TradingDaysSpec.automatic(LengthOfPeriodType.LeapYear, TradingDaysSpec.AutoMethod.FTEST, 0.01, false);
        EasterSpec ec = (EasterSpec)e.toBuilder().type(EasterSpec.Type.IncludeEaster).test(true).build();
        CalendarSpec cwd = (CalendarSpec)CalendarSpec.builder().easter(e).tradingDays(wd).build();
        CalendarSpec ctd = (CalendarSpec)CalendarSpec.builder().easter(e).tradingDays(td).build();
        OutlierSpec o = (OutlierSpec)OutlierSpec.builder().ao(true).tc(true).ls(true).build();
        TR1 = (TramoSpec)TramoSpec.builder().transform(TransformSpec.DEFAULT_AUTO).outliers(o).build();
        TR2 = (TramoSpec)TramoSpec.builder().transform(TransformSpec.DEFAULT_AUTO).outliers(o).regression((RegressionSpec)RegressionSpec.builder().mean(MeanSpec.DEFAULT_USED).calendar(cwd).build()).build();
        TR3 = (TramoSpec)TramoSpec.builder().transform(TransformSpec.DEFAULT_AUTO).outliers(o).usingAutoModel(true).build();
        TR4 = (TramoSpec)TramoSpec.builder().transform(TransformSpec.DEFAULT_AUTO).outliers(o).regression((RegressionSpec)RegressionSpec.builder().calendar(cwd).build()).usingAutoModel(true).build();
        TR5 = (TramoSpec)TramoSpec.builder().transform(TransformSpec.DEFAULT_AUTO).outliers(o).regression((RegressionSpec)RegressionSpec.builder().calendar(ctd).build()).usingAutoModel(true).build();
        CalendarSpec cc = (CalendarSpec)CalendarSpec.builder().easter(ec).tradingDays(dc).build();
        RegressionSpec rc = (RegressionSpec)RegressionSpec.builder().calendar(cc).build();
        TRfull = (TramoSpec)TramoSpec.builder().transform(TransformSpec.DEFAULT_AUTO).outliers(o).regression(rc).usingAutoModel(true).build();
    }

    public static class Builder
    implements Validatable.Builder<TramoSpec> {
        @Generated
        private SarimaSpec arima;
        @Generated
        private TransformSpec transform;
        @Generated
        private AutoModelSpec autoModel;
        @Generated
        private EstimateSpec estimate;
        @Generated
        private OutlierSpec outliers;
        @Generated
        private RegressionSpec regression;

        public Builder usingAutoModel(boolean enableAutoModel) {
            if (this.autoModel.isEnabled() != enableAutoModel) {
                this.autoModel = enableAutoModel ? AutoModelSpec.DEFAULT_ENABLED : AutoModelSpec.DEFAULT_DISABLED;
            }
            return this;
        }

        public Builder arima(@NonNull SarimaSpec sarima) {
            if (sarima == null) {
                throw new NullPointerException("sarima is marked non-null but is null");
            }
            this.arima = sarima;
            this.autoModel = AutoModelSpec.DEFAULT_DISABLED;
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder transform(@NonNull TransformSpec transform) {
            if (transform == null) {
                throw new NullPointerException("transform is marked non-null but is null");
            }
            this.transform = transform;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder autoModel(@NonNull AutoModelSpec autoModel) {
            if (autoModel == null) {
                throw new NullPointerException("autoModel is marked non-null but is null");
            }
            this.autoModel = autoModel;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder estimate(@NonNull EstimateSpec estimate) {
            if (estimate == null) {
                throw new NullPointerException("estimate is marked non-null but is null");
            }
            this.estimate = estimate;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outliers(@NonNull OutlierSpec outliers) {
            if (outliers == null) {
                throw new NullPointerException("outliers is marked non-null but is null");
            }
            this.outliers = outliers;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder regression(@NonNull RegressionSpec regression) {
            if (regression == null) {
                throw new NullPointerException("regression is marked non-null but is null");
            }
            this.regression = regression;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull TramoSpec buildWithoutValidation() {
            return new TramoSpec(this.arima, this.transform, this.autoModel, this.estimate, this.outliers, this.regression);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TramoSpec.Builder(arima=" + String.valueOf(this.arima) + ", transform=" + String.valueOf(this.transform) + ", autoModel=" + String.valueOf(this.autoModel) + ", estimate=" + String.valueOf(this.estimate) + ", outliers=" + String.valueOf(this.outliers) + ", regression=" + String.valueOf(this.regression) + ")";
        }
    }
}

