/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import jdplus.tramoseats.base.core.tramo.ModelStatistics;

public class ModelComparator {
    private final Preference preference;
    private final double significance;
    private final double kbic;
    private final double kq;
    private final double kqs;
    private final int mout;
    private final int kout;
    private final double knz;
    private final double ksk;
    private boolean acceptableQ;
    private boolean acceptableOut;
    private boolean acceptableSk;
    private boolean acceptableQS;
    private boolean acceptableStab;

    public static Builder builder() {
        return new Builder();
    }

    public ModelComparator(Builder builder) {
        this.preference = builder.preference;
        this.significance = builder.significance;
        this.kbic = builder.kbic;
        this.kq = builder.kq;
        this.kqs = builder.kqs;
        this.mout = builder.mout;
        this.kout = builder.kout;
        this.knz = builder.knz;
        this.ksk = builder.ksk;
    }

    public int compare(RegSarimaModelling m1, RegSarimaModelling m2) {
        if (m1 == m2) {
            return 0;
        }
        ModelStatistics s1 = ModelStatistics.of(m1.getDescription(), (ConcentratedLikelihood)m1.getEstimation().getConcentratedLikelihood());
        ModelStatistics s2 = ModelStatistics.of(m2.getDescription(), (ConcentratedLikelihood)m2.getEstimation().getConcentratedLikelihood());
        if (this.preference == Preference.BIC && s2.getBic() < s1.getBic() || this.preference == Preference.Second) {
            if (!this.preferSecondModel(s2, s1)) {
                return 1;
            }
            return -1;
        }
        if (!this.preferSecondModel(s1, s2)) {
            return -1;
        }
        return 1;
    }

    private boolean preferSecondModel(ModelStatistics s1, ModelStatistics s2) {
        if (!this.checkAcceptable(s1, s2)) {
            return false;
        }
        return this.test1(s1, s2) || this.test2(s1, s2) || this.test3(s1, s2) || this.test4(s1, s2) || this.test5(s1, s2);
    }

    private boolean test1(ModelStatistics s1, ModelStatistics s2) {
        if (s1.getLjungBoxPvalue() >= this.significance) {
            return false;
        }
        return s1.getLjungBox() > s2.getLjungBox() * this.kq;
    }

    private boolean test2(ModelStatistics s1, ModelStatistics s2) {
        if ((double)s1.getOutliersCount() <= (double)s1.getObservationsCount() * this.knz) {
            return false;
        }
        return s1.getOutliersCount() > s2.getOutliersCount() + this.mout;
    }

    private boolean test3(ModelStatistics s1, ModelStatistics s2) {
        if (s1.getSeasonalLjungBoxPvalue() >= this.significance) {
            return false;
        }
        return s1.getSeasonalLjungBox() > s2.getSeasonalLjungBox() * this.kqs;
    }

    private boolean test4(ModelStatistics s1, ModelStatistics s2) {
        if (s1.getSkewnessPvalue() >= this.significance) {
            return false;
        }
        return s1.getSkewnessAbsvalue() > s2.getSkewnessAbsvalue() * this.ksk;
    }

    private int stabilityScore(ModelStatistics s) {
        int c = 0;
        if (s.getStableMeanPvalue() < this.significance) {
            ++c;
        }
        if (s.getStableVariancePvalue() < this.significance) {
            ++c;
        }
        return c;
    }

    private boolean test5(ModelStatistics s1, ModelStatistics s2) {
        return this.stabilityScore(s1) > this.stabilityScore(s2);
    }

    private boolean checkAcceptable(ModelStatistics s1, ModelStatistics s2) {
        if (s2.getBic() - s1.getBic() >= Math.abs(s1.getBic()) * this.kbic) {
            return false;
        }
        this.acceptableQ = s2.getLjungBox() < s1.getLjungBox() * this.kq || s2.getLjungBoxPvalue() > this.significance;
        this.acceptableOut = s2.getOutliersCount() < s1.getOutliersCount() + 3 || (double)s2.getOutliersCount() < this.knz * (double)s2.getObservationsCount();
        this.acceptableSk = s2.getSkewnessAbsvalue() < s1.getSkewnessAbsvalue() * this.ksk || s2.getSkewnessPvalue() > this.significance;
        this.acceptableQS = s2.getSeasonalLjungBox() < s1.getSeasonalLjungBox() * this.kqs || s2.getSeasonalLjungBoxPvalue() > this.significance;
        this.acceptableStab = s2.getStableMeanPvalue() > this.significance;
        return this.acceptableQ && this.acceptableOut && this.acceptableSk && this.acceptableQS;
    }

    public static class Builder {
        private Preference preference = Preference.BIC;
        private double significance = 0.01;
        private double kbic = 0.03;
        private double kq = 1.1;
        private double kqs = 1.1;
        private int mout = 2;
        private int kout = 4;
        private double knz = 0.05;
        private double ksk = 1.25;

        public Builder preference(Preference preference) {
            this.preference = preference;
            return this;
        }

        public Builder significance(double significance) {
            this.significance = significance;
            return this;
        }

        public Builder bicTolerance(double bic) {
            if (bic < 0.0) {
                throw new IllegalArgumentException();
            }
            this.kbic = bic;
            return this;
        }

        public Builder ljungBoxTolerance(double kq) {
            if (kq < 1.0) {
                throw new IllegalArgumentException();
            }
            this.kq = kq;
            return this;
        }

        public Builder seasonalLjungBoxTolerance(double kqs) {
            if (kqs < 1.0) {
                throw new IllegalArgumentException();
            }
            this.kqs = kqs;
            return this;
        }

        public Builder skewnessTolerance(double ksk) {
            if (ksk < 1.0) {
                throw new IllegalArgumentException();
            }
            this.ksk = ksk;
            return this;
        }

        public Builder relativeOutliersThreshold(double knz) {
            if (knz >= 0.5 || knz < 0.0) {
                throw new IllegalArgumentException();
            }
            this.knz = knz;
            return this;
        }

        public Builder outliersTolerance(int m) {
            this.mout = m;
            return this;
        }

        public ModelComparator build() {
            return new ModelComparator(this);
        }
    }

    public static enum Preference {
        BIC,
        First,
        Second;

    }
}

