/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.protobuf;

import jdplus.tramoseats.base.api.seats.DecompositionSpec;
import jdplus.tramoseats.base.protobuf.DecompositionSpec;
import jdplus.tramoseats.base.protobuf.SeatsAlgorithm;
import jdplus.tramoseats.base.protobuf.SeatsApproximation;
import lombok.Generated;

public final class DecompositionProto {
    public static void fill(jdplus.tramoseats.base.api.seats.DecompositionSpec spec, DecompositionSpec.Builder builder) {
        builder.setXlBoundary(spec.getXlBoundary()).setTrendBoundary(spec.getTrendBoundary()).setSeastolerance(spec.getSeasTolerance()).setSeasBoundary(spec.getSeasBoundary()).setSeasBoundaryAtPi(spec.getSeasBoundaryAtPi()).setNfcasts(spec.getForecastCount()).setNbcasts(spec.getBackcastCount()).setApproximation(DecompositionProto.convert(spec.getApproximationMode())).setAlgorithm(DecompositionProto.convert(spec.getMethod())).setBiasCorrection(spec.getBiasCorrection() != DecompositionSpec.BiasCorrection.None);
    }

    public static DecompositionSpec convert(jdplus.tramoseats.base.api.seats.DecompositionSpec spec) {
        DecompositionSpec.Builder builder = DecompositionSpec.newBuilder();
        DecompositionProto.fill(spec, builder);
        return builder.build();
    }

    public static jdplus.tramoseats.base.api.seats.DecompositionSpec convert(DecompositionSpec spec) {
        return (jdplus.tramoseats.base.api.seats.DecompositionSpec)jdplus.tramoseats.base.api.seats.DecompositionSpec.builder().xlBoundary(spec.getXlBoundary()).trendBoundary(spec.getTrendBoundary()).seasTolerance(spec.getSeastolerance()).seasBoundary(spec.getSeasBoundary()).seasBoundaryAtPi(spec.getSeasBoundaryAtPi()).forecastCount(spec.getNfcasts()).backcastCount(spec.getNbcasts()).biasCorrection(spec.getBiasCorrection() ? DecompositionSpec.BiasCorrection.Legacy : DecompositionSpec.BiasCorrection.None).approximationMode(DecompositionProto.convert(spec.getApproximation())).method(DecompositionProto.convert(spec.getAlgorithm())).build();
    }

    static SeatsApproximation convert(DecompositionSpec.ModelApproximationMode app) {
        switch (app) {
            case Legacy: {
                return SeatsApproximation.SEATS_APP_LEGACY;
            }
            case Noisy: {
                return SeatsApproximation.SEATS_APP_NOISY;
            }
        }
        return SeatsApproximation.SEATS_APP_NONE;
    }

    static SeatsAlgorithm convert(DecompositionSpec.ComponentsEstimationMethod method) {
        switch (method) {
            case KalmanSmoother: {
                return SeatsAlgorithm.SEATS_ALG_KALMANSMOOTHER;
            }
        }
        return SeatsAlgorithm.SEATS_ALG_BURMAN;
    }

    static DecompositionSpec.ModelApproximationMode convert(SeatsApproximation app) {
        switch (app) {
            case SEATS_APP_LEGACY: {
                return DecompositionSpec.ModelApproximationMode.Legacy;
            }
            case SEATS_APP_NOISY: {
                return DecompositionSpec.ModelApproximationMode.Noisy;
            }
        }
        return DecompositionSpec.ModelApproximationMode.None;
    }

    static DecompositionSpec.ComponentsEstimationMethod convert(SeatsAlgorithm method) {
        switch (method) {
            case SEATS_ALG_KALMANSMOOTHER: {
                return DecompositionSpec.ComponentsEstimationMethod.KalmanSmoother;
            }
        }
        return DecompositionSpec.ComponentsEstimationMethod.Burman;
    }

    @Generated
    private DecompositionProto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

