% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_regarima.R
\name{set_tradingdays}
\alias{set_tradingdays}
\title{Set Calendar effects correction in Pre-Processing Specification}
\usage{
set_tradingdays(
  x,
  option = c(NA, "TradingDays", "WorkingDays", "TD2c", "TD3", "TD3c", "TD4", "None",
    "UserDefined"),
  calendar.name = NA,
  uservariable = NA,
  stocktd = NA,
  test = c(NA, "None", "Remove", "Add", "Separate_T", "Joint_F"),
  coef = NA,
  coef.type = c(NA, "Fixed", "Estimated"),
  automatic = c(NA, "Unused", "FTest", "WaldTest", "Aic", "Bic"),
  pftd = NA,
  autoadjust = NA,
  leapyear = c(NA, "LeapYear", "LengthOfPeriod", "None"),
  leapyear.coef = NA,
  leapyear.coef.type = c(NA, "Fixed", "Estimated")
)
}
\arguments{
\item{x}{the specification to customize, must be a "SPEC" class object (see
details).}

\item{option}{to specify the set of trading days regression variables:
\itemize{
\item \code{"TradingDays"} = six contrast variables, each type of day (from
Monday to Saturday) vs Sundays;
\item \code{"WorkingDays"} = one working (week days) vs non-working (week-ends) day
contrast variable;
\item \code{"TD2c"} = one working (Mondays to Saturdays) vs non-working (Sundays) day
contrast variable;
\item \code{"TD3"} = two contrast variables: week-days vs Sundays and  Saturdays
vs Sundays;
\item \code{"TD3c"} = two contrast variables: week-days (Mondays to Thursdays)
vs Sundays and  Fridays+Saturdays vs Sundays;
\item \code{"TD4"} = three contrast variables: week-days (Mondays to Thursdays)
vs Sundays, Fridays vs Sundays, Saturdays vs Sundays;
\item \code{"None"} = no correction for trading days;
\item \code{"UserDefined"} = userdefined trading days regressors.
}}

\item{calendar.name}{name (string) of the user-defined calendar to be taken
into account when generating built-in regressors set in \code{option} (if
not \code{"UserDefined"}).(see examples)}

\item{uservariable}{a vector of characters to specify the name of
user-defined calendar regressors. When specified, automatically set
\code{option = "UserDefined"}. Names have to be the same as in
\code{\link{modelling_context}}, see example.}

\item{stocktd}{a numeric indicating the day of the month when inventories
and other stock are reported (to denote the last day of the month, set the
variable to 31). When specified, automatically set \code{option = "None"}.
See \code{stock_td} function for details.}

\item{test}{defines the pre-tests for the significance of the trading day
regression variables based on the AICC statistics: \code{"None"} = the
trading day variables are not pre-tested and are included in the model;

(REGARIMA/X-13 specific)
\itemize{
\item \code{"Add"} = the trading day variables are not included in the initial
regression model but can be added to the RegARIMA model after the test;
\item \code{"Remove"} = the trading day variables belong to the initial
regression model but can be removed from the RegARIMA model after the
test;
}

(TRAMO specific)
\itemize{
\item \code{"Separate_T"} = a t-test is applied to each trading day variable
separately and the trading day variables are included in the RegArima
model if at least one t-statistic is greater than 2.6 or if two
t-statistics are greater than 2.0 (in absolute terms);
\item \code{"Joint_F"} = a joint F-test of significance of all the trading day
variables. The trading day effect is significant if the F statistic is
greater than 0.95.
}}

\item{coef}{vector of coefficients for the trading-days regressors.}

\item{coef.type, leapyear.coef.type}{vector defining if the coefficients are
fixed or estimated.}

\item{automatic}{defines whether the calendar effects should be added to the
model manually (\code{"Unused"}) or automatically. During the automatic
selection, the choice of the number of calendar variables can be based on
the F-Test (\code{"FTest"}, TRAMO specific), the Wald Test
(\code{"WaldTest"}), or by minimizing AIC or BIC; the model with higher
F-value is chosen, provided that it is higher than \code{pftd}).}

\item{pftd}{(TRAMO SPECIFIC) \code{numeric}. The p-value used to assess the
significance of the pre-tested calendar effects.}

\item{autoadjust}{a logical indicating if the program corrects automatically
the raw series for the leap year effect if the leap year regressor is
significant. Only used when the data is log transformed.}

\item{leapyear}{a \code{character} to specify whether or not to include the
leap-year effect in the model:
\itemize{
\item \code{"LeapYear"} = leap year effect;
\item \code{"LengthOfPeriod"} = length of period (REGARIMA/X-13 specific),
\item \code{"None"} = no effect included.
Default: a leap year effect regressor is included with any built-in set of
trading day regressors.
}}

\item{leapyear.coef}{coefficient of the leap year regressor.}
}
\value{
The modified specification (with new trading days variables)
}
\description{
Function allowing to select the trading-days regressors to be used for
calendar correction in the pre-processing step of a seasonal adjustment
procedure. The default is \code{"TradingDays"}, with easter specific effect
enabled. (see \code{\link{set_easter}})

All the built-in regressors are meant to correct for type of day effect but
don't take into account any holiday. To do so user-defined regressors have to
be built.
}
\details{
\code{x} specification parameter must be a JD3_X13_SPEC" class object
generated with \code{rjd3x13::x13_spec()} (or "JD3_REGARIMA_SPEC" generated
with \code{rjd3x13::spec_regarima()} or "JD3_TRAMOSEATS_SPEC" generated with
\code{rjd3tramoseats::spec_tramoseats()} or "JD3_TRAMO_SPEC" generated with
\code{rjd3tramoseats::spec_tramo()}).
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Pre-defined regressors
y_raw <- ABS$X0.2.09.10.M

# Customize a default specification
init_spec <- x13_spec_default

# Estimation on sub-span between two dates (date d1 is excluded)
new_spec <- set_tradingdays(
    init_spec,
    option = "TD4",
    test = "None",
    coef = c(0.7, NA, 0.5),
    coef.type = c("Fixed", "Estimated", "Fixed"),
    leapyear = "LengthOfPeriod",
    leapyear.coef = 0.6
)

# Pre-defined regressors based on user-defined calendar
### create a calendar
BE <- national_calendar(list(
    fixed_day(7, 21),
    special_day("NEWYEAR"),
    special_day("CHRISTMAS"),
    special_day("MAYDAY"),
    special_day("EASTERMONDAY"),
    special_day("ASCENSION"),
    special_day("WHITMONDAY"),
    special_day("ASSUMPTION"),
    special_day("ALLSAINTSDAY"),
    special_day("ARMISTICE")
))
## Put into a context
my_context <- modelling_context(calendars = list(cal = BE))

## Modify the specification
new_spec <- set_tradingdays(
    init_spec,
    option = "TradingDays",
    calendar.name = "cal"
)

## Estimate with context
# sa <- rjd3x13::x13(y_raw, new_spec, context = my_context)

regs_td <- rjd3toolkit::td(
    s = y_raw,
    groups = c(1, 2, 0, 4, 5, 6, 3),
    contrasts = TRUE
)

variables <- list(
    Monday = regs_td[, 1],
    Tuesday = regs_td[, 2],
    Wednesday = regs_td[, 3],
    Thursday = regs_td[, 4],
    Friday = regs_td[, 5],
    Saturday = regs_td[, 6]
)
# Add regressors to context
my_context <- modelling_context(variables = variables)

# Create a new spec (here default group name: r)
new_spec <- set_tradingdays(
    init_spec,
    option = "UserDefined",
    uservariable = c("r.Monday", "r.Tuesday", "r.Wednesday",
                     "r.Thursday", "r.Friday", "r.Saturday"),
    test = "None"
)

# Estimate with context
# sa <- rjd3x13::x13(y_raw, new_spec, context = my_context)
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{modelling_context}}, \code{\link{calendar_td}}
}
