% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.likelihood}
\alias{.likelihood}
\title{Information on the (log-)likelihood}
\usage{
.likelihood(
  nobs,
  neffectiveobs = NA,
  nparams = 0,
  ll,
  adjustedll = NA,
  aic,
  aicc,
  bic,
  bicc,
  ssq
)
}
\arguments{
\item{nobs}{Number of observations}

\item{neffectiveobs}{Number of effective observations. NA if the same as nobs.}

\item{nparams}{Number of hyper-parameters}

\item{ll}{Log-likelihood}

\item{adjustedll}{Adjusted log-likelihood when the series has been transformed}

\item{aic}{AIC}

\item{aicc}{AICC}

\item{bic}{BIC}

\item{bicc}{BIC corrected for the length}

\item{ssq}{Sum of the squared residuals}
}
\value{
Returns a java object of class JD3_LIKELIHOOD.
}
\description{
Function allowing to gather information on likelihood estimation
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}

# Values used below are taken from the following estimation
# m <- rjd3x13::x13(rjd3toolkit::ABS$X0.2.09.10.M, "rsa3")
# m$result$preprocessing$estimation$likelihood
ll_estimation <- .likelihood(425, 4, 7, 720.2, -2147.407, 4308.14, 4309.09,
                             4333.96, 433.962, 0.0418)
\dontshow{\}) # examplesIf}
}
