% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jd3spreadsheet.R
\name{spreadsheet_id_to_properties}
\alias{spreadsheet_id_to_properties}
\title{Gets the list of the properties corresponding to the identifier of a moniker.}
\usage{
spreadsheet_id_to_properties(id)
}
\arguments{
\item{id}{Identifier of a series or of a collection of series.}
}
\value{
Returns a list with the elements of the id: file, sheet, series, gathering); the gathering is a list with the following items: period (-1 by default), the aggregation ("None"), partialAggregation (FALSE), includeMissing (FALSE).
}
\description{
Gets the list of the properties corresponding to the identifier of a moniker.
}
\details{
When the period in the gathering list is defined, the user must specify the aggregation type ("Sum", "Average", "First", "Last", "Min", "Max") and some additional parameters (partial aggregation and suppression of leading/trailing missing values).
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
set_spreadsheet_paths(system.file("extdata", package = "rjd3providers"))
xls_s1_3 <- spreadsheet_series("Insee.xlsx", 1, 3)
id<-xls_s1_3$moniker$id
print(spreadsheet_id_to_properties(id))
}
\dontshow{\}) # examplesIf}
}
\seealso{
[spreadsheet_properties_to_id()]
}
