% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestroute_cleanup.R
\name{connectsegs}
\alias{connectsegs}
\title{Connect Segments}
\usage{
connectsegs(
  connect,
  connectto,
  nearestvert = TRUE,
  rivers,
  calcconnections = TRUE
)
}
\arguments{
\item{connect}{The segment(s) to connect to the network.  Typically, this is the
segment that is disconnected from the rest of the river network.  A vector of segments may be used.}

\item{connectto}{The segment(s) to connect it (them) to.  Typically, this is a segment
that is connected to the rest of the river network.  A vector of segments may be used, corresponding to that used in \code{connect=}.}

\item{nearestvert}{Whether to connect at the nearest vertex and split the
segment (\code{FALSE}), or connect at the nearest endpoint (\code{TRUE}). 
Defaults to \code{TRUE}.  A vector may be used, corresponding to those used in \code{connect=} and \code{connectto=}.}

\item{rivers}{The river network object to use.}

\item{calcconnections}{Whether to recalculate all connections. 
Defaults to \code{TRUE}.  Setting to \code{FALSE} is not recommended unless many connections are to be made, in which case connections can be calculated afterward.}
}
\value{
A new river network object with the specified segments connected (see
  \link{rivernetwork})
}
\description{
Provides a method to manually connect unconnected segments
  within a river network.  The nearest endpoint (or vertex) of the second segment is
  added as a new vertex to the first, and the network topology is then updated.
}
\note{
This function is called within \link{cleanup}, which is recommended in
  most cases.
}
\examples{
data(Koyukuk0)
plot(Koyukuk0, ylim=c(1930500,1931500), xlim=c(194900,195100))
topologydots(Koyukuk0, add=TRUE)

Koyukuk0.1 <- connectsegs(connect=21, connectto=20, rivers=Koyukuk0)
plot(Koyukuk0.1,ylim=c(1930500,1931500), xlim=c(194900,195100))
topologydots(Koyukuk0.1, add=TRUE)

# or the vector version
zoomtoseg(seg=21:23, rivers=Koyukuk0)
Koyukuk0.2 <- connectsegs(connect=c(20,21,22), connectto=c(21,22,23), 
    nearestvert=c(FALSE,FALSE,TRUE), rivers=Koyukuk0)
zoomtoseg(seg=21:23, rivers=Koyukuk0.2)
topologydots(Koyukuk0.2, add=TRUE)
}
\seealso{
line2network
}
\author{
Matt Tyers
}
