% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_download.R
\name{get_cran_total_downloads}
\alias{get_cran_total_downloads}
\title{Get CRAN Total or Recent Downloads for a Package}
\usage{
get_cran_total_downloads(pkg, months = NULL)
}
\arguments{
\item{pkg}{Character string, the name of the CRAN package.}

\item{months}{Integer. If NULL, returns all-time total; otherwise, returns total from the last `months` full months (excluding current).}
}
\value{
An integer: total number of downloads.
}
\description{
Retrieves either all-time total downloads or the total from the last `n` full months
for a given CRAN package.
}
\details{
Similar data can be obtained via:

https://cranlogs.r-pkg.org/badges/grand-total/ggplot2
https://cranlogs.r-pkg.org/badges/last-month/ggplot2
}
\examples{
\dontrun{
  get_cran_total_downloads("ggplot2")        # all-time total
  # 160776616

  get_cran_total_downloads("ggplot2", 3)     # last 3 full months
  # 4741707

  get_cran_total_downloads("ggplot2", 12)    # last 12 full months
  # 19878885
}

}
