% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rintcal.R
\name{glue.ccurves}
\alias{glue.ccurves}
\title{Glue calibration curves}
\usage{
glue.ccurves(
  prebomb = "IntCal20",
  postbomb = "NH1",
  thisprebombcurve = c(),
  thispostbombcurve = c(),
  as.F = FALSE,
  as.pMC = FALSE,
  as.Delta = FALSE,
  cc.dir = c(),
  decimals = 8
)
}
\arguments{
\item{prebomb}{The prebomb curve. Defaults to "IntCal20"}

\item{postbomb}{The postbomb curve. Defaults to "NH1" (Hua et al. 2013)}

\item{thisprebombcurve}{As an alternative to using existing curves, a tailor-made curve can be provided for the prebomb curve (as three columns: cal BP, C14 age, error)}

\item{thispostbombcurve}{As an alternative to using existing curves, a tailor-made curve can be provided for the postbomb curve (as three columns: cal BP, C14 age, error)}

\item{as.F}{The glued curve can be returned as F14C values instead of the default C14. Make sure that if as.F=TRUE and you are using thisprebombcurve and/or thispostbombcurve, that these curves are in F14C space already.}

\item{as.pMC}{The curves can be returned as pMC values instead of the default C14. Make sure that if as.pMC=TRUE and you are using thiscurve1 and/or thiscurve2, that these curves are in pMC space already.}

\item{as.Delta}{The curves can be returned as D14C values instead of the default C14. Make sure that if as.Delta=TRUE and you are using thiscurve1 and/or thiscurve2, that these curves are in Delta14C space already.}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="ccurves"}.}

\item{decimals}{Number of decimals to report when as.F=TRUE. Defaults to 5.}
}
\value{
The custom-made curve (invisibly)
}
\description{
Produce a custom curve by merging two calibration curves, e.g. a prebomb and a postbomb one for dates which straddle both curves.
}
\examples{
my.cc <- glue.ccurves()
}
