% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank-wt.R
\name{rank_gwt}
\alias{rank_gwt}
\title{Generalized weighted ranking function}
\usage{
rank_gwt(x, wt)
}
\arguments{
\item{x}{numeric vector}

\item{wt}{weights}
}
\value{
A numeric vector containing weighted fractional ranks of the elements of \code{x}.
}
\description{
In the case of ties, the ordinary \code{rank_wt()} function uses the order in the original data.
This is the same approach as in the Stata code provided by O’Donnell et al. (2008) in the original World Bank publication,
but depends on the arbitrary initial order in the data
The Stat conindex code however uses uses the generalized weighted rank implementation published by van Ourti (2004). For Stata compatibility use \code{rank_gwt()}
}
\details{
The formula notation in van Ourti (2004) seems to rely on absolute an absolute deduction of 1 unit of monetary income value. This only works
in the integer case. Instead, this this implementation uses the next lowest \code{x} value, respectively the next lowest rank, to calculate the
proportion of the inequality variable up to the respective value
}
\examples{
x <- sample(1:10, size = 10, replace = TRUE)
x.weight <- seq(0, 1, length.out = 10)
rank_gwt(x, wt = x.weight)
}
\references{
van Ourti, T., 2004. Measuring horizontal inequity in Belgian health care using a Gaussian random effects two part count data model. Health Economics, 13: 705–724.
}
