% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lincom.R
\name{lincom}
\alias{lincom}
\alias{lincom.do}
\alias{print.lincom}
\title{Tests of Linear Combinations of Regression Coefficients}
\usage{
lincom(
  reg,
  comb,
  null.hypoth = 0,
  conf.level = 0.95,
  robustSE = TRUE,
  joint.test = FALSE,
  useFdstn = FALSE,
  eform = reg$fnctl != "mean"
)
}
\arguments{
\item{reg}{an object of class \code{uRegress}.}

\item{comb}{a vector or matrix containing the values of the constants which
create the linear combination of the form \deqn{c_0 + c_1\beta_1 + \dots}
Zeroes must be given if coefficients aren't going to be included. For testing
multiple combinations, this must be a matrix with number of columns equal to the number of
coefficients in the model.}

\item{null.hypoth}{the null hypothesis to compare the linear combination of
coefficients against. This is a scalar if one combination is given, and a 
vector or matrix otherwise. The default value is \code{0}.}

\item{conf.level}{a number between 0 and 1, indicating the desired
confidence level for intervals.}

\item{robustSE}{a logical value indicating whether or not to use robust
standard errors in calculation. Defaults to \code{TRUE}. 
If \code{TRUE}, then \code{robustSE} must
have been \code{TRUE} when \code{reg} was created.}

\item{joint.test}{a logical value indicating whether or not to use a joint Chi-square test 
for all the null hypotheses. If joint.test is \code{TRUE}, then no confidence interval is calculated. 
Defaults to \code{FALSE}.}

\item{useFdstn}{a logical indicator that the F distribution should be used for test statistics 
instead of the chi squared distribution. Defaults to \code{TRUE}. This option is not supported when 
input \code{reg} is a hazard regression (i.e., \code{fnctl="hazard"}).}

\item{eform}{a logical value indicating whether or not to exponentiate the
estimated coefficient. By default this is performed based on the type of
regression used.}
}
\value{
A list of class \code{lincom} (\code{joint.test} is \code{False}) or 
\code{lincom.joint} (\code{joint.test} is \code{True}). For the \code{lincom} class,
\code{comb} entries in the list are labeled \code{comb1}, \code{comb2}, etc. for as many linear combinations were used. 
Each is a list with the following components:
\describe{
\item{printMat}{A formatted table with inferential results for the linear combination of coefficients. 
These include the point estimate, standard error, confidence interval, and t-test for the linear 
combination.}
\item{nms}{The name of the linear combination, for printing.}
\item{null.hypoth}{The null hypothesis for the linear combination.}}
}
\description{
Produces point estimates, interval estimates, and p-values for linear
combinations of regression coefficients using a \code{uRegress} object.
}
\examples{
# Loading required libraries
library(sandwich)

# Reading in a dataset
data(mri)

# Linear regression of LDL on age (with robust SE by default)
testReg <- regress ("mean", ldl~age+stroke, data = mri)

# Testing coefficient created by .5*age - stroke (the first 0 comes from excluding the intercept)
testC <- c(0, 0.5, -1)
lincom(testReg, testC)

# Test multiple combinations: 
# whether separately whether .5*age - stroke = 0 or Intercept + 60*age = 125 
testC <- matrix(c(0, 0.5, -1, 1, 60, 0), byrow = TRUE, nrow = 2)
lincom(testReg, testC, null.hypoth = c(0, 125))

# Test joint null hypothesis:
# H0: .5*age - stroke = 0 AND Intercept + 60*age = 125 
lincom(testReg, testC, null.hypoth = c(0, 125), joint.test = TRUE)

}
