## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ricci)

# enable optional simplfying procedures
# (takes a toll on performance)
options(ricci.auto_simplify = TRUE)

g_eucl_cart(3)

g_eucl_sph(3)

## -----------------------------------------------------------------------------
"1/r" |> covd(.(k), g = g_eucl_sph(3))

## -----------------------------------------------------------------------------
"1/r" |> covd(.(k, l), g = g_eucl_sph(3))

## -----------------------------------------------------------------------------
# electromagnetic potential
A <- c("1/r", "0", "0", "0")

A %_% .(m) |>
  covd(.(n), g = g_mink_sph(4)) |>
  asym(m, n)

## -----------------------------------------------------------------------------
# on scalar field
"1/r" |> covd(.(k, +k), g = g_mink_sph(4))

# on a vector field
A %_% .(i) |> covd(.(k, +k), g = g_mink_sph(4))

## -----------------------------------------------------------------------------
g <- g_eucl_sph(3)

g %_% .(i, j) |>
  covd(.(k), g = g) |>
  as_a(i, j, k)

