% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chip.R
\name{read_chip}
\alias{read_chip}
\title{Read CHIP file}
\usage{
read_chip(x)
}
\arguments{
\item{x}{File name}
}
\value{
A data.frame is returned with three columns: \code{ProbeSetID},
\code{GeneSymbol} and \code{GeneTitle}. The column names are concordant with
the GSEA convention, except that the empty spaces are omitted.
}
\description{
The CHIP file format is commonly used to annotate probesets or other
identifiers to gene symbols and gene names.  This function imports CHIP
files, using a C procedure to accelerate the speed.
}
\details{
The current implementation only parses the first three columns and ignores
the rest of columns. This behavior may change in future versions to provide
larger flexibility of parsing CHIP-like files.
}
\examples{

  testFile <- system.file("extdata/test.chip", package="ribiosIO")
  testChip <- read_chip(testFile)
  head(testChip)
  stopifnot(identical(colnames(testChip), c("ProbeSetID", "GeneSymbol", "GeneTitle")))

}
\references{
BROAD institute GSEA manual, available at
\url{https://software.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats}.
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
