% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{gd_search}
\alias{gd_search}
\title{Search an Image Collection}
\usage{
gd_search(
  x,
  region,
  start_date = "2000-01-01",
  end_date = as.character(Sys.Date()),
  ...
)
}
\arguments{
\item{x}{A \code{geedim.collection.ImageCollectionAccessor} (for geedim >= 2.0.0) or \code{geedim.MaskedCollection} (for geedim < 2.0.0) object. See \verb{\link{geedim-versions}} for more details.}

\item{region}{list / Python GeoJSON object describing region, e.g. as created by \code{gd_bbox()}}

\item{start_date}{Default: \code{'2020-01-01'}}

\item{end_date}{Default: \code{Sys.Date()}}

\item{...}{additional arguments to \code{geedim.MaskedCollection.search()} e.g. \code{cloudless_portion}, \code{fill_portion}}
}
\value{
A \code{geedim.collection.ImageCollectionAccessor} (for geedim >= 2.0.0) or \code{geedim.MaskedCollection} (for geedim < 2.0.0) object suitable for querying properties. See \verb{\link{geedim-versions}} for more details.
}
\description{
Search an Image Collection
}
\examples{
\dontshow{if (isTRUE(as.logical(Sys.getenv("R_RGEEDIM_RUN_EXAMPLES"))) && gd_is_initialized() && !inherits(requireNamespace("terra", quietly=TRUE), 'try-error')) withAutoprint(\{ # examplesIf}
\donttest{
b <- terra::vect('POLYGON((-121.355 37.56,-121.355 37.555,
                    -121.35 37.555,-121.35 37.56,
                    -121.355 37.56))',
          crs = "OGC:CRS84")
if (gd_is_initialized())
  gd_search(gd_collection_from_name("USGS/3DEP/1m"),
            region = gd_region(b))
}
\dontshow{\}) # examplesIf}
}
