#' Get distance between two mutations
#'
#' @param mut1.start The start position of the first mutation
#' @param mut1.end The end position of the first mutation
#' @param mut1.type The type of the first mutation: "SNV", "DEL", "INS" or "DELINS"
#' @param mut2.start The start position of the second mutation
#' @param mut2.end The end position of the second mutation
#' @param mut2.type The type of the second mutation: "SNV", "DEL", "INS" or "DELINS"
#' 
#' @return A distance between two mutations in 5' to 3' direction
#' 
#' @examples
#' \dontrun{
#'     getMutationsDistance()
#' }
#'
#' @noRd
getMutationsDistance <- function(
		mut1.start, 
		mut1.end,
		mut1.type,  
		mut2.start, 
		mut2.end,
		mut2.type ){
	if( mut1.type=="INS" & mut2.type=="INS" ){
		mut1.end <- mut1.start
		mut2.end <- mut2.start
	}
	if( mut1.type=="INS" & mut2.type=="DELINS" ){
		mut2.end <- mut2.end - 1
	}
	if( mut1.type=="DELINS" & mut2.type=="INS" ){
		mut1.end <- mut1.end - 1
	}
    if( mut1.type=="DELINS" & mut2.type=="DELINS" ){
        mut1.end <- mut1.end - 1
        mut2.end <- mut2.end - 1
    }
	ovlp <- intersect( c(mut1.start:mut1.end), c(mut2.start:mut2.end) )
	if( length(ovlp)>0 ){
		dist.sec2orig <- 0
	}else{
		d1 <- mut2.start - mut1.end
		d2 <- mut2.end - mut1.start
		dist.sec2orig <- sign(d1) * min( abs(d1), abs(d2) )
	}
	return(dist.sec2orig)
}
