/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import java.io.Closeable;
import java.util.Arrays;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.propagation.PropagationEngineObserver;
import org.chocosolver.solver.propagation.PropagationObserver;
import org.chocosolver.solver.propagation.PropagationProfiler;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.SolvingStatisticsFlow;
import org.chocosolver.solver.trace.GephiGenerator;
import org.chocosolver.solver.trace.GephiNetwork;
import org.chocosolver.solver.trace.GraphvizGenerator;
import org.chocosolver.solver.trace.IMessage;
import org.chocosolver.solver.trace.LogStatEveryXXms;
import org.chocosolver.solver.trace.VerboseSolving;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.StringUtils;

public interface IOutputFactory
extends ISelf<Solver> {
    public static final String WELCOME_MESSAGE = "** Choco 5.0.0-beta.1 (2025-02) : Constraint Programming Solver, Copyright (c) 2010-2025";

    default public void printVersion() {
        ((Solver)this.ref()).log().bold().blue().println(WELCOME_MESSAGE);
    }

    default public void printFeatures() {
        ((Solver)this.ref()).getMeasures().setReadingTimeCount(System.nanoTime() - ((Solver)this.ref()).getModel().getCreationTime());
        ((Solver)this.ref()).log().printf("- Model[%s] features:\n", ((Solver)this.ref()).getModel().getName());
        ((Solver)this.ref()).log().printf("\tLCG : %s\n", ((Solver)this.ref()).isLCG());
        ((Solver)this.ref()).log().printf("\tVariables : %d\n", ((Solver)this.ref()).getModel().getNbVars());
        ((Solver)this.ref()).log().printf("\tConstraints : %d\n", ((Solver)this.ref()).getModel().getNbCstrs());
        ((Solver)this.ref()).log().printf("\tBuilding time : %.3fs\n", Float.valueOf(((Solver)this.ref()).getMeasures().getReadingTimeCount()));
        ((Solver)this.ref()).log().printf("\tUser-defined search strategy : %s\n", ((Solver)this.ref()).getModel().getSolver().isDefaultSearchUsed() ? "no" : "yes");
        ((Solver)this.ref()).log().printf("\tComplementary search strategy : %s\n", ((Solver)this.ref()).isSearchCompleted() ? "yes" : "no");
    }

    default public void printShortFeatures() {
        ((Solver)this.ref()).getMeasures().setReadingTimeCount(System.nanoTime() - ((Solver)this.ref()).getModel().getCreationTime());
        String st = "Model[" + ((Solver)this.ref()).getModelName() + "], " + String.format("%d variables, %d constraints, building time: %.3fs, %s user-defined search strategy, %s complementary search strategy", ((Solver)this.ref()).getModel().getNbVars(), ((Solver)this.ref()).getModel().getNbCstrs(), Float.valueOf(((Solver)this.ref()).getMeasures().getReadingTimeCount()), ((Solver)this.ref()).getModel().getSolver().isDefaultSearchUsed() ? "w/" : "w/o", ((Solver)this.ref()).isSearchCompleted() ? "w/" : "w/o");
        ((Solver)this.ref()).log().bold().println(st);
    }

    default public void printStatistics() {
        this.printVersion();
        this.printFeatures();
        ((Solver)this.ref()).log().println(((Solver)this.ref()).getMeasures().toString());
    }

    default public void printShortStatistics() {
        ((Solver)this.ref()).log().println(((Solver)this.ref()).getMeasures().toOneLineString());
    }

    default public void printCSVStatistics() {
        ((Solver)this.ref()).log().println(((Solver)this.ref()).getMeasures().toCSV());
    }

    default public void showStatistics() {
        ((Solver)this.ref()).plugMonitor(new IMonitorInitialize(){

            @Override
            public void beforeInitialize() {
                IOutputFactory.this.printVersion();
                IOutputFactory.this.printFeatures();
            }
        });
        ((Solver)this.ref()).plugMonitor(new IMonitorClose(){

            @Override
            public void afterClose() {
                ((Solver)IOutputFactory.this.ref()).log().println(((Solver)IOutputFactory.this.ref()).getMeasures().toString());
            }
        });
    }

    default public void showShortStatistics() {
        ((Solver)this.ref()).plugMonitor(new IMonitorClose(){

            @Override
            public void beforeClose() {
                IOutputFactory.this.printShortStatistics();
            }
        });
    }

    default public void showShortStatisticsOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Solver)this.ref()).printShortStatistics()));
    }

    default public void showSolutions(IMessage message) {
        ((Solver)this.ref()).plugMonitor(() -> ((Solver)this.ref()).log().println(message.print()));
    }

    default public void showSolutions() {
        this.showSolutions(new DefaultSolutionMessage((Solver)this.ref()));
    }

    default public void showSolutions(Variable ... variables) {
        this.showSolutions(new DefaultSolutionMessage((Solver)this.ref(), variables));
    }

    default public void showDecisions(final IMessage message) {
        ((Solver)this.ref()).plugMonitor(new IMonitorDownBranch(){
            final /* synthetic */ IOutputFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void beforeDownBranch(boolean left) {
                ((Solver)this.this$0.ref()).log().printf("%s %s ", StringUtils.pad("", ((Solver)this.this$0.ref()).getEnvironment().getWorldIndex(), "."), ((Solver)this.this$0.ref()).getDecisionPath().lastDecisionToString());
                ((Solver)this.this$0.ref()).log().printf(" // %s \n", message.print());
            }
        });
    }

    default public void showDecisions() {
        this.showDecisions(120);
    }

    default public void showDecisions(int nChars) {
        this.showDecisions(new DefaultDecisionMessage((Solver)this.ref(), nChars));
    }

    default public void showRestarts(final IMessage message) {
        ((Solver)this.ref()).plugMonitor(new IMonitorRestart(){
            final /* synthetic */ IOutputFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void afterRestart() {
                ((Solver)this.this$0.ref()).log().printf("RUNS %d ", ((Solver)this.this$0.ref()).getRestartCount());
                ((Solver)this.this$0.ref()).log().printf(" // %s \n", message.print());
            }
        });
    }

    default public void showRestarts() {
        this.showRestarts(() -> ((Solver)this.ref()).toOneLineString());
    }

    default public void showContradiction() {
        ((Solver)this.ref()).plugMonitor(cex -> ((Solver)this.ref()).log().red().println(String.format("\t/!\\ %s", cex.toString())));
    }

    default public void showStatisticsDuringResolution(long f) {
        if (f > 0L) {
            ((Solver)this.ref()).plugMonitor(new LogStatEveryXXms((Solver)this.ref(), f));
        }
    }

    default public void verboseSolving(long frequencyInMilliseconds) {
        ((Solver)this.ref()).plugMonitor(new VerboseSolving((Solver)this.ref(), frequencyInMilliseconds));
    }

    default public void showDashboard() {
        this.showDashboard(100L);
    }

    @Deprecated
    default public void showDashboard(long refresh) {
    }

    default public void observePropagation(PropagationObserver po) {
        ((Solver)this.ref()).setEngine(new PropagationEngineObserver(((Solver)this.ref()).getModel(), po));
    }

    default public PropagationProfiler profilePropagation() {
        PropagationProfiler po = new PropagationProfiler(((Solver)this.ref()).getModel());
        ((Solver)this.ref()).observePropagation(po);
        return po;
    }

    default public SolvingStatisticsFlow observeSolving() {
        return new SolvingStatisticsFlow((Solver)this.ref());
    }

    default public Closeable outputSearchTreeToGraphviz(String gvFilename) {
        return new GraphvizGenerator(gvFilename, (Solver)this.ref());
    }

    default public Closeable outputSearchTreeToGephi(String gexfFilename) {
        return new GephiGenerator(gexfFilename, (Solver)this.ref());
    }

    @Deprecated
    default public Closeable outputSearchTreeToCPProfiler(boolean domain) {
        return null;
    }

    default public void constraintNetworkToGephi(String gexfFilename) {
        GephiNetwork.write(gexfFilename, ((Solver)this.ref()).getModel());
    }

    public static class DefaultSolutionMessage
    implements IMessage {
        private final Solver solver;
        private Variable[] vars;

        public DefaultSolutionMessage(Solver solver) {
            this(solver, null);
        }

        public DefaultSolutionMessage(Solver solver, Variable[] vars) {
            this.solver = solver;
            this.vars = vars;
        }

        @Override
        public String print() {
            if (this.vars == null) {
                this.vars = (Variable[])Arrays.stream(this.solver.getSearch().getVariables()).distinct().toArray(Variable[]::new);
            }
            return String.format("- Solution #%s found. %s \n\t%s.", this.solver.getSolutionCount(), this.solver.getMeasures().toOneLineString(), this.printVars());
        }

        private String printVars() {
            StringBuilder s = new StringBuilder(32);
            for (Variable v : this.vars) {
                s.append(v).append(' ');
            }
            return s.toString();
        }
    }

    public static class DefaultDecisionMessage
    implements IMessage {
        private final Solver solver;
        private final int limit;

        public DefaultDecisionMessage(Solver solver, int nChars) {
            this.solver = solver;
            this.limit = nChars;
        }

        @Override
        public String print() {
            Variable[] vars = this.solver.getSearch().getVariables();
            StringBuilder s = new StringBuilder(32);
            for (int i = 0; i < vars.length && s.length() < this.limit; ++i) {
                s.append(vars[i]).append(' ');
            }
            if (s.length() >= this.limit) {
                s.append("...");
            }
            return s.toString();
        }
    }
}

