/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.IntNeighbor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.MathUtils;

public class ReversePropagationGuidedNeighborhood
extends IntNeighbor {
    protected final int n;
    protected int[] domSiz;
    protected int[] all;
    protected Random rd;
    final double desiredSize;
    double size;
    int listSize;
    double logSum = 0.0;
    private double epsilon = 1.0;
    List<Integer> candidates;
    protected BitSet fragment;
    protected Model mModel;

    public ReversePropagationGuidedNeighborhood(IntVar[] vars, int desiredSize, int listSize, long seed) {
        super(vars);
        this.mModel = vars[0].getModel();
        this.n = vars.length;
        this.rd = new Random(seed);
        this.desiredSize = desiredSize;
        this.listSize = listSize;
        this.all = new int[this.n];
        this.domSiz = new int[this.n];
        this.candidates = new ArrayList<Integer>();
        this.fragment = new BitSet(this.n);
    }

    @Override
    public void fixSomeVariables() throws ContradictionException {
        this.logSum = 0.0;
        this.size = this.desiredSize * this.epsilon;
        this.fragment.set(0, this.n);
        try {
            this.update();
            this.epsilon = 0.95 * this.epsilon + 0.05 * (this.logSum / this.size);
        }
        catch (ContradictionException ce) {
            this.epsilon = 0.95 * this.epsilon + 0.05 / this.size;
            throw ce;
        }
    }

    protected void update() throws ContradictionException {
        while (this.logSum < this.size && this.fragment.cardinality() > 0) {
            int id = this.selectVariable();
            if (this.variables[id].contains(this.values[id])) {
                this.logSum += MathUtils.log2(this.variables[id].getDomainSize());
                this.mModel.getSolver().pushTrail();
                this.variables[id].instantiateTo(this.values[id], (ICause)Cause.Null);
                this.mModel.getSolver().propagate();
                this.fragment.clear(id);
                for (int i2 = 0; i2 < this.n; ++i2) {
                    int ds = this.variables[i2].getDomainSize();
                    if (!this.fragment.get(i2)) continue;
                    if (ds == 1) {
                        this.fragment.clear(i2);
                        continue;
                    }
                    this.all[i2] = (int)((double)(this.domSiz[i2] - ds) / ((double)this.domSiz[i2] * 1.0) * 100.0);
                }
                this.mModel.getSolver().cancelTrail();
                this.candidates = IntStream.range(0, this.n).filter(i -> this.fragment.get(i) && this.all[i] > 0).boxed().sorted(Comparator.comparingInt(i -> -this.all[i])).limit(this.listSize).collect(Collectors.toList());
                continue;
            }
            this.fragment.clear(id);
        }
        int i3 = this.fragment.nextSetBit(0);
        while (i3 > -1 && i3 < this.n) {
            if (this.variables[i3].contains(this.values[i3])) {
                this.freeze(i3);
            }
            i3 = this.fragment.nextSetBit(i3 + 1);
        }
    }

    int selectVariable() {
        int id;
        if (this.candidates.isEmpty()) {
            id = this.fragment.nextSetBit(0);
            for (int cc = this.rd.nextInt(this.fragment.cardinality()); id >= 0 && cc > 0; --cc) {
                id = this.fragment.nextSetBit(id + 1);
            }
        } else {
            id = this.candidates.remove(0);
        }
        return id;
    }

    @Override
    public void init() {
        this.domSiz = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.domSiz[i] = this.variables[i].getDomainSize();
        }
    }
}

