% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-get-tools.R
\name{gb_definition_get}
\alias{gb_definition_get}
\title{Get definition from GenBank}
\usage{
gb_definition_get(id)
}
\arguments{
\item{id}{character, sequence accession ID(s)}
}
\value{
named vector of definitions, if no results found NULL
}
\description{
Return the definition line
for an accession ID.
}
\examples{
library(restez)
restez_path_set(filepath = tempdir())
demo_db_create(n = 5)
(def <- gb_definition_get(id = 'demo_1'))
(defs <- gb_definition_get(id = c('demo_1', 'demo_2')))


# delete demo after example
db_delete(everything = TRUE)
}
\seealso{
\code{\link[=ncbi_acc_get]{ncbi_acc_get()}}

Other get: 
\code{\link{gb_fasta_get}()},
\code{\link{gb_organism_get}()},
\code{\link{gb_record_get}()},
\code{\link{gb_sequence_get}()},
\code{\link{gb_version_get}()}
}
\concept{get}
