% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{summary.flag_resp}
\alias{summary.flag_resp}
\title{Summary function for flag_resp() output}
\usage{
\method{summary}{flag_resp}(object, normalize = F, ...)
}
\arguments{
\item{object}{An object of type \code{flag_resp} which is created using the \code{flag_resp()}
function.}

\item{normalize}{A logical value indicating, whether to normalize the agreement
estimates between flagging strategies. See details for more information.}

\item{...}{Other arguments for summary functions (currently not supported).}
}
\value{
An object of class "summary_flag_resp". The object works like a list
with four elements.
\itemize{
\item n_flagged: a named vector of the number of cases a flagging strategy flagged as positive.
\item agreement: a data frame which counts the number of cases two flagging strategies flagged
as positive. If \code{normalized}, the values are the percentage agreement in flagged respondents.
\item normalized: Indicator if agreement values were normalized.
\item n: number of rows in \code{object}.
}
}
\description{
Calculates the number of respondents flagged with a flagging strategy. Also
calculates the agreement between flagging strategies.
}
\details{
The agreement is either the count of respondents which two flagging strategies
flag (\code{normalize = T}) or the number of respondents that is flagged positive by
at least one flagging strategy.

In logical terms, the normalized agreement is \code{sum(fs1 & fs2) / sum(fs1 | fs2)}.
}
\examples{
resp_distributions(nep) |>
  flag_resp(ii_mean > 3,
   ii_sd > 1,
   ii_mean > 3 & ii_sd > 1) |>
  summary()

}
