% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reservoir.R
\name{generate_data}
\alias{generate_data}
\title{Load data from the \code{Japanese vowels} or the \code{Mackey-Glass}}
\usage{
generate_data(
  dataset = c("japanese_vowels", "mackey_glass", "both"),
  one_hot_encode = TRUE,
  repeat_targets = FALSE,
  reload = FALSE,
  n_timesteps,
  tau = 17,
  a = 0.2,
  b = 0.1,
  n = 10,
  x0 = 1.2,
  h = 1
)
}
\arguments{
\item{dataset}{(String) take value in array \code{[japanese_vowels,mackey_glass]}}

\item{one_hot_encode}{(bool), default to True. If True, returns class label as a one-hot encoded vector.}

\item{repeat_targets}{(bool), default to False. If True, repeat the target label or vector along the time axis of the corresponding sample.}

\item{reload}{(bool), default to False
If True, re-download data from remote repository. Else, if a cached version
of the dataset exists, use the cached dataset.}

\item{n_timesteps}{(int) Number of time steps to compute.}

\item{tau}{(int), default to 17 
Time delay :math:`\\tau` of Mackey-Glass equation.
By defaults, equals to 17. Other values can
change the choatic behaviour of the timeseries.}

\item{a}{(float) default to 0.2
:math:`a` parameter of the equation.}

\item{b}{(float) default to 0.1
:math:`b` parameter of the equation.}

\item{n}{(int) default to 10
:math:`n` parameter of the equation.}

\item{x0}{(float), optional, default to 1.2
Initial condition of the timeseries.}

\item{h}{(float), default to 1.0
Time delta between two discrete timesteps.}
}
\value{
array of shape (n_timesteps, 1) Mackey-Glass timeseries.
}
\description{
Mackey-Glass time series \code{[8]_ [9]_}, computed from the Mackey-Glass
delayed differential equation:
}
\examples{
if(interactive()){
japanese_vowels <- generate_data(dataset="japanese_vowels")
timeSerie <- generate_data(dataset = "mackey_glass",n_timesteps = 2500)
res =generate_data(dataset <- "both",n_timesteps = 2500)
}
}
