% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{writeFuture}
\alias{writeFuture}
\title{Write to cache repository, using \code{future::future}}
\usage{
writeFuture(
  written,
  outputToSave,
  cachePath,
  userTags,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  cacheId,
  linkToCacheId = NULL,
  verbose = getOption("reproducible.verbose")
)
}
\arguments{
\item{written}{Integer. If zero or positive then it needs to be written still.
Should be 0 to start.}

\item{outputToSave}{The R object to save to repository}

\item{cachePath}{The file path of the repository}

\item{userTags}{Character string of tags to attach to this \code{outputToSave} in
the \code{CacheRepo}}

\item{drv}{If using a database backend, \code{drv} must be an object that
inherits from \code{DBIDriver} (e.g., \code{RSQLite::SQLite}).}

\item{conn}{an optional \code{DBIConnection} object, as returned by \code{dbConnect()}.}

\item{cacheId}{Character string. If passed, this will override the calculated hash
of the inputs, and return the result from this \code{cacheId} in the \code{cachePath}.
Setting this is equivalent to manually saving the output of this function, i.e.,
the object will be on disk, and will be recovered in subsequent
This may help in some particularly finicky situations
where \code{Cache} is not correctly detecting unchanged inputs. This will guarantee
the object will be identical each time; this may be useful in operational code.}

\item{linkToCacheId}{Optional. If a \code{cacheId} is provided here, then a \code{file.link}
will be made to the file with that \code{cacheId} name in the cache repo.
This is used when identical outputs exist in the cache. This will save disk space.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\value{
Run for its side effect.
This will add the \code{objectToSave} to the cache located at \code{cachePath},
using \code{cacheId} as its id, while
updating the database entry. It will do this using the future package, so it is
written in a future.
}
\description{
This will be used internally if \code{options("reproducible.futurePlan" = TRUE)}.
This is still experimental.
}
