## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)

## ----global-------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
outdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"outdir")
dir.create(outdir,showWarnings=FALSE)
suppressMessages(
  repfun::rs_setup(
    D_CENTID="SITEID",
    D_DATADATE=Sys.Date(),
    D_DSPLYNUM=1,
    D_DSPLYTYP=T,
    D_FONTSIZE=10,
    D_FOOT1='1.) Only treatment emergent events related to lipids are displayed.',
    D_FOOT2='2.) Subjects are only counted once within each body system and preferred term.',
    D_KEEPPOPVARS=c('STUDYID','USUBJID','SAFFL'),
    D_OUTFILE=paste0(outdir,"/t_ru_list_1.rtf"),
    D_PGMPTH="./Global-Reporting-Setup.Rmd",
    D_STUDYID='ABCXYZPDQ',
    D_POP="SAFFL",
    D_POPDATA= repfun::adsl %>% dplyr::filter(SAFFL=='Y'),
    D_POPLBL="Safety",
    D_SUBJID=c("STUDYID","USUBJID"),
    D_TITLE1=paste0('Table 1: Summary of Treatment Emergent Adverse Events'),
    D_USERID=Sys.getenv("DOMINO_USER_NAME"),
    R_DICTION="../inst/formats",
    R_MACDIRS=c("."),
    R_DDDATA=paste0(tmpdr,'/t_ru_list_1.rds'),
    R_OTHERDATA=datdir,
    R_INPUTDATA=datdir,
    R_RAWDATA=datdir,
    R_SDTMDATA=datdir,
    R_ADAMDATA=datdir,
    D_RTFYN="Y",
    D_DEBUG=0)
    )

## ----subset-------------------------------------------------------------------
adae <- repfun:::rfenv$adamdata$adae.rda() %>% dplyr::filter(TRTEMFL=='Y') -> adsl1

## ----display------------------------------------------------------------------
knitr::kable(head(adae[,c(1:10)],10), caption = paste0("TEAEs for Study: ", repfun:::rfenv$G_STUDYID))

