% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/af_old.R
\name{af_old}
\alias{af_old}
\title{Construct an FGAM regression term}
\usage{
af_old(
  X,
  argvals = seq(0, 1, l = ncol(X)),
  xind = NULL,
  basistype = c("te", "t2", "s"),
  integration = c("simpson", "trapezoidal", "riemann"),
  L = NULL,
  splinepars = list(bs = "ps", k = c(min(ceiling(nrow(X)/5), 20), min(ceiling(ncol(X)/5),
    20)), m = list(c(2, 2), c(2, 2))),
  presmooth = TRUE,
  Xrange = range(X),
  Qtransform = FALSE
)
}
\arguments{
\item{X}{an \code{N} by \code{J=ncol(argvals)} matrix of function evaluations
\eqn{X_i(t_{i1}),., X_i(t_{iJ}); i=1,.,N.}}

\item{argvals}{matrix (or vector) of indices of evaluations of \eqn{X_i(t)}; i.e. a matrix with
\emph{i}th row \eqn{(t_{i1},.,t_{iJ})}}

\item{xind}{Same as argvals. It will discard this argument in the next version of refund.}

\item{basistype}{defaults to \code{"te"}, i.e. a tensor product spline to represent \eqn{F(x,t)} Alternatively,
use \code{"s"} for bivariate basis functions (see \code{{s}}) or \code{"t2"} for an alternative
parameterization of tensor product splines (see \code{{t2}})}

\item{integration}{method used for numerical integration. Defaults to \code{"simpson"}'s rule for
calculating entries in \code{L}. Alternatively and for non-equidistant grids, \code{"trapezoidal"}
or \code{"riemann"}. \code{"riemann"} integration is always used if \code{L} is specified}

\item{L}{optional weight matrix for the linear functional}

\item{splinepars}{optional arguments specifying options for representing and penalizing the
function \eqn{F(x,t)}. Defaults to a cubic tensor product B-spline with marginal second-order
difference penalties, i.e. \code{list(bs="ps", m=list(c(2, 2), c(2, 2))}, see \code{{te}} or
\code{{s}} for details}

\item{presmooth}{logical; if true, the functional predictor is pre-smoothed prior to fitting; see
\code{{smooth.basisPar}}}

\item{Xrange}{numeric; range to use when specifying the marginal basis for the \emph{x}-axis.  It may
be desired to increase this slightly over the default of \code{range(X)} if concerned about predicting
for future observed curves that take values outside of \code{range(X)}}

\item{Qtransform}{logical; should the functional be transformed using the empirical cdf and
applying a quantile transformation on each column of \code{X} prior to fitting?  This ensures
\code{Xrange=c(0,1)}.  If \code{Qtransform=TRUE} and \code{presmooth=TRUE}, presmoothing is done prior
to transforming the functional predictor}
}
\value{
A list with the following entries:
\enumerate{
\item \code{call} - a \code{"call"} to \code{te} (or \code{s}, \code{t2}) using the appropriately
constructed covariate and weight matrices.
\item \code{argvals} - the \code{argvals} argument supplied to \code{af}
\item \code{L}-the  matrix of weights used for the integration
\item \code{xindname} - the name used for the functional predictor variable in the \code{formula} used by \code{mgcv}.
\item \code{tindname} - the name used for \code{argvals} variable in the \code{formula} used by \code{mgcv}
\item \code{Lname} - the name used for the \code{L} variable in the \code{formula} used by \code{mgcv}
\item \code{presmooth} - the \code{presmooth} argument supplied to \code{af}
\item \code{Qtranform} - the \code{Qtransform} argument supplied to \code{af}
\item \code{Xrange} - the \code{Xrange} argument supplied to \code{af}
\item \code{ecdflist} - a list containing one empirical cdf function from applying \code{{ecdf}}
to each (possibly presmoothed) column of \code{X}.  Only present if \code{Qtransform=TRUE}
\item \code{Xfd} - an \code{fd} object from presmoothing the functional predictors using
\code{{smooth.basisPar}}.  Only present if \code{presmooth=TRUE}.  See \code{{fd}}.
}
}
\description{
Defines a term \eqn{\int_{T}F(X_i(t),t)dt} for inclusion in an \code{mgcv::gam}-formula (or
\code{{bam}} or \code{{gamm}} or \code{gamm4:::gamm}) as constructed by
\code{{fgam}}, where \eqn{F(x,t)}$ is an unknown smooth bivariate function and \eqn{X_i(t)}
is a functional predictor on the closed interval \eqn{T}. Defaults to a cubic tensor product
B-spline with marginal second-order difference penalties for estimating \eqn{F(x,t)}.  The
functional predictor must be fully observed on a regular grid
}
\references{
McLean, M. W., Hooker, G., Staicu, A.-M., Scheipl, F., and Ruppert, D. (2014). Functional
generalized additive models. \emph{Journal of Computational and Graphical Statistics}, \bold{23 (1)},
pp. 249-269.
}
\seealso{
\code{{fgam}}, \code{{lf}}, mgcv's \code{{linear.functional.terms}},
\code{{fgam}} for examples
}
\author{
Mathew W. McLean \email{mathew.w.mclean@gmail.com} and Fabian Scheipl
}
