% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialisation.R
\name{object_to_string}
\alias{object_to_string}
\alias{string_to_object}
\alias{object_to_bin}
\alias{bin_to_object}
\title{Convert R objects to/from strings}
\usage{
object_to_string(obj)

string_to_object(str)

object_to_bin(obj, xdr = FALSE)

bin_to_object(bin)
}
\arguments{
\item{obj}{An R object to convert into a string}

\item{str}{A string to convert into an R object}

\item{xdr}{Use the big-endian representation?  Unlike,
\code{\link[=serialize]{serialize()}} this is disabled here by default as it is a bit
faster (~ 20\%, saving about 1 microsecond of a 5 microsecond
roundtrip for a serialization of 100 doubles)}

\item{bin}{A binary vector to convert back to an R object}
}
\description{
Serialise/deserialise an R object into a string.  This is a very
thin wrapper around the existing R functions \code{\link[=serialize]{serialize()}} and
\code{\link[=rawToChar]{rawToChar()}}.  This is useful to encode arbitrary R objects as
string to then save in Redis (which expects a string).
}
\examples{
s <- object_to_string(1:10)
s
string_to_object(s)
identical(string_to_object(s), 1:10)
}
