% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{save_parquet}
\alias{save_parquet}
\title{Save Data to Parquet}
\usage{
save_parquet(
  conn,
  file_path = "redcap.parquet",
  table_name = NULL,
  query = NULL
)
}
\arguments{
\item{conn}{A DuckDB connection object.}

\item{file_path}{Character string specifying the output file path.
Default is "redcap.parquet".}

\item{table_name}{Character string specifying the source table name.
If NULL, uses the table name stored in connection attributes.
Default is NULL.}

\item{query}{Character string with custom SQL query to export.
If provided, table_name is ignored.}
}
\value{
Invisible NULL. Side effect: creates Parquet file at specified path.
}
\description{
Saves data directly from the database to a Parquet file using
DuckDB's native COPY command. This is much faster than reading
into R first and creates smaller files for easy sharing. Uses the data table name
stored in the connection attributes if available.
}
\examples{
\dontrun{
# Save entire data table
save_parquet(conn, "redcap.parquet")
}

}
