% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_countries.R
\name{rl_countries}
\alias{rl_countries}
\title{Retrieve IUCN Red List assessments by country}
\usage{
rl_countries(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character. One or more countries ISO alpha-2 code.
Use \code{\link[=rl_countries]{rl_countries()}} to list available countries codes.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available country codes.
If \code{code} is provided, the tibble contains assessment data for the specified country code(s), including taxon details,
red list category, year, and other relevant metadata
}
\description{
Retrieves the species assessed by the IUCN for a specified countries.
See \code{code} argument for available countries codes
}
\examples{
\dontrun{
  # Retrieve assessments for Benin (country code "BJ") for the year 2020
  rl_countries("BJ", year = 2020)

  # Retrieve all assessments for Brazil (country code "BR")
  rl_countries("BR", page = 2)

  # Retrieve assessments for Canada (country code "CA") on specific pages
  rl_countries("CA", page = c(1, 2))
}
}
