% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eo_import_logs.R
\name{eo_import_logs}
\alias{eo_import_logs}
\title{imports log files from Eosense chambers}
\usage{
eo_import_logs(
  path,
  closed = c(1:3),
  open = 0,
  fully_closed = 1,
  colnames = c("port", "valvestatus", "chamberstatus", "aux1", "aux2", "aux3", "aux4",
    "aux5", "temperaturev", "pressure"),
  nb_ports = 12
)
}
\arguments{
\item{path}{folder in which the log files are located}

\item{closed}{status numbers indicating chamber is closed}

\item{open}{status numbers indicating chamber is open}

\item{fully_closed}{status number indicating the chamber is fully closed}

\item{colnames}{column names as defined in Eosense documentation}

\item{nb_ports}{number of ports}
}
\value{
a dataframe with all the information from the logs and measurement id
}
\description{
imports log files from Eosense chambers
}
\examples{
path <- system.file("extdata/ex_logs", package = "readosense")
eo_import_logs(path)
}
