% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsr_dual_stays.R
\name{hsr_dual_stays}
\alias{hsr_dual_stays}
\title{Extract dually-eligible discharges from a Hospital-Specific Report (HSR)}
\usage{
hsr_dual_stays(file)
}
\arguments{
\item{file}{File path to a report}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}
}
\description{
Parses the discharge-level records from the HSR of patients who were
dually-eligible for Medicare and Medicaid benefits (see details).

\emph{\strong{Note}: CMS changed the format of Hospital-Specific Reports (HSRs) for FY2026 (see \href{https://qualitynet.cms.gov/inpatient/hrrp/reports#tab2}{here}). The current HSR functions support formats through FY2025.}
}
\details{
In the \href{https://www.cms.gov/medicare/payment/prospective-payment-systems/acute-inpatient-pps/hospital-readmissions-reduction-program-hrrp}{Hospital Readmissions Reduction Program (HRRP)},
hospitals' readmission rates are compared against a peer group of "like" hospitals, which determines whether or not they will
get penalized financially.

The peer group allocation done by \href{https://www.cms.gov/}{CMS} is determined by creating hospital groupings based
on the share of Medicare beneficiaries who were also eligible for Medicaid benefits, a marker of socioeconomic status
in the hospital population. \code{hsr_dual_stays()} extracts the list of discharges accounting for the numerator of this ratio.
}
\examples{
# Access a report
my_report <- hsr_mock_reports("FY2025_HRRP_MockHSR.xlsx")

# Extract dually-eligible stays as a dataset
hsr_dual_stays(my_report)
}
