% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsr_coefficients.R
\name{hsr_coefficients}
\alias{hsr_coefficients}
\title{Extract risk model coefficients from a Hospital-Specific Report (HSR)}
\usage{
hsr_coefficients(file, cohort)
}
\arguments{
\item{file}{File path to a report}

\item{cohort}{Cohort to extract the coefficients for. One of \code{c("AMI", "COPD", "HF", "PN", "CABG", "HK")}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} containing the columns:
\itemize{
\item \code{Factor}: The model term name (as listed in the file)
\item \code{Value}: The model coefficient value (on the linear predictor scale)
}
}
\description{
Parses out the regression coefficients from the logistic regression model
used by CMS to estimate discharge-level readmission risk,
including the hospital-level and hospital average intercept terms.

\emph{\strong{Note}: CMS changed the format of Hospital-Specific Reports (HSRs) for FY2026 (see \href{https://qualitynet.cms.gov/inpatient/hrrp/reports#tab2}{here}). The current HSR functions support formats through FY2025.}
}
\examples{
# Access a report
my_report <- hsr_mock_reports("FY2025_HRRP_MockHSR.xlsx")

# Show coefficients for heart failure model
hsr_coefficients(my_report, "HF")
}
