% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_estimates_by_size.R
\name{read_estimates_by_size}
\alias{read_estimates_by_size}
\alias{read_est_by_size}
\title{Read ABARES' "Estimates by Size"}
\source{
\url{https://www.agriculture.gov.au/sites/default/files/documents/fdp-national-historical.csv}.
}
\usage{
read_estimates_by_size(x = NULL)

read_est_by_size(x = NULL)
}
\arguments{
\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} object with the \code{Variable} field as the
\code{key}.
}
\description{
Fetches and imports \acronym{ABARES} estimates by size data.
}
\note{
Columns are renamed for consistency with other \acronym{ABARES} products
serviced in this package using a snake_case format and ordered consistently.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}

read_estimates_by_size()

# or shorter
read_est_by_size()
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.agriculture.gov.au/abares/data/farm-data-portal#data-download}.
}
\seealso{
Other Estimates: 
\code{\link{read_estimates_by_performance_category}()},
\code{\link{read_historical_national_estimates}()},
\code{\link{read_historical_regional_estimates}()},
\code{\link{read_historical_state_estimates}()}
}
\concept{Estimates}
