% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{reactableLang}
\alias{reactableLang}
\title{Language options}
\usage{
reactableLang(
  sortLabel = "Sort {name}",
  filterPlaceholder = "",
  filterLabel = "Filter {name}",
  searchPlaceholder = "Search",
  searchLabel = "Search",
  noData = "No rows found",
  pageNext = "Next",
  pagePrevious = "Previous",
  pageNumbers = "{page} of {pages}",
  pageInfo = "{rowStart}\u2013{rowEnd} of {rows} rows",
  pageSizeOptions = "Show {rows}",
  pageNextLabel = "Next page",
  pagePreviousLabel = "Previous page",
  pageNumberLabel = "Page {page}",
  pageJumpLabel = "Go to page",
  pageSizeOptionsLabel = "Rows per page",
  groupExpandLabel = "Toggle group",
  detailsExpandLabel = "Toggle details",
  selectAllRowsLabel = "Select all rows",
  selectAllSubRowsLabel = "Select all rows in group",
  selectRowLabel = "Select row",
  defaultGroupHeader = NULL,
  detailsCollapseLabel = NULL,
  deselectAllRowsLabel = NULL,
  deselectAllSubRowsLabel = NULL,
  deselectRowLabel = NULL
)
}
\arguments{
\item{sortLabel}{Accessible label for column sort buttons.
Takes a \code{{name}} parameter for the column name.}

\item{filterPlaceholder}{Placeholder for column filter inputs.}

\item{filterLabel}{Accessible label for column filter inputs.
Takes a \code{{name}} parameter for the column name.}

\item{searchPlaceholder}{Placeholder for the table search input.}

\item{searchLabel}{Accessible label for the table search input.}

\item{noData}{Placeholder text when the table has no data.}

\item{pageNext}{Text for the next page button.}

\item{pagePrevious}{Text for the previous page button.}

\item{pageNumbers}{Text for the page numbers info. Only used with the \code{"jump"} and
\code{"simple"} pagination types.
Takes the following parameters:
\itemize{
\item \code{{page}} for the current page
\item \code{{pages}} for the total number of pages
}}

\item{pageInfo}{Text for the page info.
Takes the following parameters:
\itemize{
\item \code{{rowStart}} for the starting row of the page
\item \code{{rowEnd}} for the ending row of the page
\item \code{{rows}} for the total number of rows
}}

\item{pageSizeOptions}{Text for the page size options input.
Takes a \code{{rows}} parameter for the page size options input.}

\item{pageNextLabel}{Accessible label for the next page button.}

\item{pagePreviousLabel}{Accessible label for the previous page button.}

\item{pageNumberLabel}{Accessible label for the page number buttons.
Only used with the the \code{"numbers"} pagination type.
Takes a \code{{page}} parameter for the page number.}

\item{pageJumpLabel}{Accessible label for the page jump input. Only used with
the \code{"jump"} pagination type.}

\item{pageSizeOptionsLabel}{Accessible label for the page size options input.}

\item{groupExpandLabel}{Accessible label for the row group expand button.}

\item{detailsExpandLabel}{Accessible label for the row details expand button.}

\item{selectAllRowsLabel}{Accessible label for the select all rows checkbox.}

\item{selectAllSubRowsLabel}{Accessible label for the select all sub rows checkbox.}

\item{selectRowLabel}{Accessible label for the select row checkbox.}

\item{defaultGroupHeader}{Deprecated and no longer used.}

\item{detailsCollapseLabel}{Deprecated and no longer used.}

\item{deselectAllRowsLabel}{Deprecated and no longer used.}

\item{deselectAllSubRowsLabel}{Deprecated and no longer used.}

\item{deselectRowLabel}{Deprecated and no longer used.}
}
\value{
A language options object that can be used to customize the language
strings in \code{reactable()}.
}
\description{
Use \code{reactableLang()} to customize the language strings in a table.
Language strings include both visible text and accessible labels that can
be read by assistive technology, such as screen readers.

To set the default language strings for all tables, use the global
\code{reactable.language} option.
}
\examples{
reactable(
  iris[1:30, ],
  searchable = TRUE,
  paginationType = "simple",
  language = reactableLang(
    searchPlaceholder = "Search...",
    noData = "No entries found",
    pageInfo = "{rowStart}\u2013{rowEnd} of {rows} entries",
    pagePrevious = "\u276e",
    pageNext = "\u276f",

    # Accessible labels for assistive technology, such as screen readers
    pagePreviousLabel = "Previous page",
    pageNextLabel = "Next page"
  )
)

# Set the default language for all tables
options(reactable.language = reactableLang(
  searchPlaceholder = "Search...",
  noData = "No entries found",
  pageInfo = "{rowStart} to {rowEnd} of {rows} entries"
))

reactable(iris[1:30, ], searchable = TRUE)

}
