% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdhte_lincom.R
\name{rdhte_lincom}
\alias{rdhte_lincom}
\title{RD Heterogeneous Treatment Effects.  Linear combinations of parameters}
\usage{
rdhte_lincom(model, linfct, level = 95, digits = 3)
}
\arguments{
\item{model}{a fitted model returned by \code{\link{rdhte}}.}

\item{linfct}{a specification of the linear hypotheses to be tested.
Linear functions can be specified by either the matrix of coefficients or by
symbolic descriptions of one or more linear hypotheses.}

\item{level}{Confidence level for intervals; default is \code{level = 95}.}

\item{digits}{Number of decimal places to format numeric outputs (default 3).}
}
\value{
A list with two data frames: 'individual' and 'joint', with rounded values.
}
\description{
\code{rdhte_lincom} computes point estimates, p-values, and
robust bias-corrected confidence intervals for linear combinations of
parameters after any estimation using \code{\link{rdhte}}
(Calonico, Cattaneo, Farrell, Palomba and Titiunik, 2025a).
Inference is implemented using robust bias-correction methods
(Calonico, Cattaneo, and Titiunik, 2014). It is based on the \code{R} function
\code{\link[multcomp]{glht}}.

Companion commands: \code{\link{rdhte}} for estimation and inference of RD-HTE
and \code{\link{rdbwhte}} for data-driven bandwidth selection.

Related software packages for analysis and interpretation of RD designs and
related methods are available in: \url{https://rdpackages.github.io/}.

For background methodology, see Calonico, Cattaneo, Farrell, and Titiunik
(2019), Calonico, Cattaneo and Farrell (2020), Cattaneo and Titiunik (2022).
}
\examples{
set.seed(123)
n <- 1000
X <- runif(n, -1, 1)
W <- rbinom(n, 1, 0.5)
Y <- 3 + 2*X + 1.5*X^2 + 0.5*X^3 + sin(2*X) + 3*W*(X>=0) + rnorm(n)
m1 <- rdhte(y = Y, x = X, covs.hte = factor(W))
linfct <- c("`factor(W)0` - `factor(W)1` = 0")
rdhte_lincom(model = m1, linfct = linfct)

}
\references{
Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): rdhte: Learning Conditional Average Treatment Effects in RD Designs. \emph{Working paper}.

Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): Treatment Effect Heterogeneity in Regression Discontinuity Designs. \emph{Working paper}
}
\seealso{
\code{\link{rdhte}}, \code{\link{rdbwhte}}
}
\author{
Sebastian Calonico, University of California, Davis \email{scalonico@ucdavis.edu}.

Matias D. Cattaneo, Princeton University  \email{cattaneo@princeton.edu}.

Max H. Farrell, University of California, Santa Barbara \email{maxhfarrell@ucsb.edu}.

Filippo Palomba, Princeton University \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University \email{titiunik@princeton.edu}.
}
