% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd2d.R
\name{summary.rd2d}
\alias{summary.rd2d}
\title{Summary Method for 2D Local Polynomial RD Estimation}
\usage{
\method{summary}{rd2d}(object, ...)
}
\arguments{
\item{object}{An object of class \code{rd2d}, typically returned by \code{\link{rd2d}}.}

\item{...}{Optional arguments. Supported options include:
\itemize{
\item \code{CBuniform}: Logical. If \code{TRUE}, displays uniform confidence bands;
if \code{FALSE} (default), displays pointwise confidence intervals.
\item \code{subset}: Integer vector of indices of evaluation points to display.
Defaults to all evaluation points.
\item \code{output}: Character. Use \code{"main"} to display estimation results,
or \code{"bw"} to display bandwidth information. Default is \code{"main"}.
\item \code{sep_main}: Integer vector of controlling the column widths of the output table when \code{output = "main"}.
Default is \code{c(4, 7, 7, 7, 7, 7, 17)}.
\item \code{sep_bw}: Integer vector of controlling the column widths of the output table when \code{output = "bw"}.
Default is \code{c(4, rep(8,8))}.
\item \code{WBATE}: Integer vector of weights for aggregated average treatment effect (WBATE). Should have non-negative entries
summing up to one. If provided, an extra row for WBATE is added to the output table.
\item \code{LBATE}: Logical. If \code{TRUE}, an extra row for largest treatment effect (LBATE) is added to the output table.
}}
}
\value{
No return value. This function is called for its side effects: it prints a formatted summary of \code{\link{rd2d}} results.
}
\description{
Summarizes estimation and bandwidth results from a 2D local polynomial regression discontinuity (RD) design, as produced by \code{\link{rd2d}}.
}
\seealso{
\code{\link{rd2d}} for estimation using 2D local polynomial RD design.

Supported methods: \code{\link{print.rd2d}}, \code{\link{summary.rd2d}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu} \cr
Rocío Titiunik, Princeton University. \email{titiunik@princeton.edu} \cr
Ruiqi Rae Yu, Princeton University. \email{rae.yu@princeton.edu}
}
