#' Multifaceted Computer Science Students Data To Identify Depression Level
#'
#' @description
#' This dataset comprises survey results from 100 computer science students,
#' aiming to identify correlations between their depression levels,
#' class performance, and ADHD patterns through data analysis. This dataset is
#' designed to facilitate a comprehensive analysis of the interplay between
#' demographic factors, academic performance, mental health, study habits, and
#' social dynamics among individuals in the specified context.
#'
#' @format a data frame with 10 columns:
#'
#'  \describe{
#'    \item{\code{Age}}{(factor) Age of each individual.}
#'    \item{\code{Gender}}{(factor) Gender of individual.}
#'    \item{\code{AcademicPerformance}}{(factor) Academic performance of each
#'    individual.}
#'    \item{\code{TakingNoteInClass}}{(factor) Note taking habits of each
#'    individual.}
#'    \item{\code{DepressionStatus}}{(factor) Presence of depression symptoms
#'    reported by each individual.}
#'    \item{\code{FaceChallengesToCompleteAcademicTask}}{(factor) Experience of
#'    facing challenges in completing academic challenges reported each
#'    individual.}
#'    \item{\code{LikePresentation}}{(factor) Like for making presentations for
#'    each individual.}
#'    \item{\code{SleepPerDayHours}}{(numeric) Average hours of sleep obtained
#'    reported by each individual.}
#'    \item{\code{NumberOfFriend}}{(numeric) Number of friends each individual
#'    reported having.}
#'    \item{\code{LikeNewThings}}{(factor) Like for new things reported by each
#'    individual.}
#'   }
#'
#' @source "Psychosocial Dimensions of Student Life" authored by Md. Ismiel
#' Hossen Abir on Kaggle:
#' https://www.kaggle.com/datasets/mdismielhossenabir/psychosocial-dimensions-of
#' -student-life
#' Last retrieved from Kaggle: 2024-10-12
#'
"student"
