% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-showinfo.R, R/op-cdo-showcode.R,
%   R/op-cdo-showdate.R, R/op-cdo-showfilter.R, R/op-cdo-showformat.R,
%   R/op-cdo-showlevel.R, R/op-cdo-showltype.R, R/op-cdo-showmon.R,
%   R/op-cdo-showname.R, R/op-cdo-showstdname.R, R/op-cdo-showtime.R,
%   R/op-cdo-showtimestamp.R, R/op-cdo-showyear.R
\name{showinfo}
\alias{showinfo}
\alias{cdo_showcode}
\alias{cdo_showdate}
\alias{cdo_showfilter}
\alias{cdo_showformat}
\alias{cdo_showlevel}
\alias{cdo_showltype}
\alias{cdo_showmon}
\alias{cdo_showname}
\alias{cdo_showstdname}
\alias{cdo_showtime}
\alias{cdo_showtimestamp}
\alias{cdo_showyear}
\title{Show variables, levels or times}
\usage{
cdo_showcode(ifile)

cdo_showdate(ifile)

cdo_showfilter(ifile)

cdo_showformat(ifile)

cdo_showlevel(ifile)

cdo_showltype(ifile)

cdo_showmon(ifile)

cdo_showname(ifile)

cdo_showstdname(ifile)

cdo_showtime(ifile)

cdo_showtimestamp(ifile)

cdo_showyear(ifile)
}
\arguments{
\item{ifile}{String with the path to the input file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module prints the format, variables, levels or times of the input dataset.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{showformat     Show file format
               Prints the file format of the input dataset.
showcode       Show code numbers
               Prints the code number of all variables.
showname       Show variable names
               Prints the name of all variables.
showstdname    Show standard names
               Prints the standard name of all variables.
showlevel      Show levels
               Prints all levels for each variable.
showltype      Show GRIB level types
               Prints the GRIB level type for all z-axes.
showyear       Show years
               Prints all years.
showmon        Show months
               Prints all months.
showdate       Show date information
               Prints date information of all timesteps (format YYYY-MM-DD).
showtime       Show time information
               Prints time information of all timesteps (format hh:mm:ss).
showtimestamp  Show timestamp
               Prints timestamp of all timesteps (format YYYY-MM-DDThh:mm:ss).
showfilter     Show filter specification
               Prints NetCDF4 filter specification of all variables.
}\if{html}{\out{</div>}}
}
