% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert_gamma_correction.R
\name{invert_gamma_correction}
\alias{invert_gamma_correction}
\title{Gamma back correction of JPEG images}
\usage{
invert_gamma_correction(dn, gamma = 2.2)
}
\arguments{
\item{dn}{numeric vector or \link[terra:SpatRaster-class]{terra::SpatRaster}. Digital
numbers from a JPEG file (range 0–255, as per standard 8-bit encoding).}

\item{gamma}{numeric vector of length one. Exponent applied in the inverse
gamma correction (typically 2.2 for sRGB).}
}
\value{
Same properties as \code{dn}, with values adjusted by
inverse gamma correction and rescaled to the range \eqn{[0, 1]}.
}
\description{
Approximates the inversion of the gamma encoding applied to JPEG
images.
}
\details{
Digital cameras typically encode images using the sRGB color space,
which applies a non-linear transformation—commonly referred to as gamma
correction—to the sensor's linear luminance response. This function applies a
power transformation to approximate the inverse of that encoding, restoring a
response closer to linear.
}
\examples{
\dontrun{
path <- system.file("external/APC_0836.jpg", package = "rcaiman")
caim <- read_caim(path)
z <- zenith_image(2132,  lens("Olloclip"))
a <- azimuth_image(z)
zenith_colrow <- c(1063, 771)

caim <- expand_noncircular(caim, z, zenith_colrow)
m <- !is.na(caim$Red) & !is.na(z)
caim[!m] <- 0

bin <- binarize_with_thr(caim$Blue, thr_isodata(caim$Blue[m]))

display_caim(caim$Blue, bin)

caim <- invert_gamma_correction(caim, 2.2)
}
}
\references{
\insertAllCited{}
}
