% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_caim.R
\name{crop_caim}
\alias{crop_caim}
\title{Crop a canopy image}
\usage{
crop_caim(r, upper_left = NULL, width = NULL, height = NULL)
}
\arguments{
\item{r}{\link[terra:SpatRaster-class]{terra::SpatRaster}.}

\item{upper_left}{numeric vector of length two. Pixel coordinates of the
upper-left corner of the ROI, in the format \code{c(column, row)}.}

\item{width, height}{numeric vector of length one. Size (in pixels) of the
rectangular ROI to read.}
}
\value{
\link[terra:SpatRaster-class]{terra::SpatRaster} object containing the same layers and values
as \code{r} but restricted to the selected ROI, preserving all other properties.
}
\description{
Extracts a rectangular region of interest (ROI) from a canopy image. This
function complements \code{\link[=read_caim]{read_caim()}} and \code{\link[=read_caim_raw]{read_caim_raw()}}.
}
\note{
\code{rcaiman} uses terra without geographic semantics: rasters are kept with
unit resolution (cell size = 1) and a standardized extent
\code{ext(0, ncol, 0, nrow)} with CRS EPSG:7589.
}
\examples{
caim <- read_caim()
ncell(caim)
caim <- crop_caim(caim, c(231,334), 15, 10)
ncell(caim)
}
