% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brand_init.R
\name{brand_init}
\alias{brand_init}
\title{Initialize branding configuration}
\usage{
brand_init(brand_url = NULL, install_path = ".")
}
\arguments{
\item{brand_url}{Optional URL. Points to the remote brand file. If \code{NULL}, defaults to
rbranding's brand file on GitHub.}

\item{install_path}{Optional string. Directory where the files should be created.
Defaults to the current working directory.}
}
\value{
NULL. Called for its side effects: downloading and creating \code{rbranding_config.yml}
and \verb{_brand.yml} files.
}
\description{
\code{brand_init} initializes the branding configuration by creating two files:
\itemize{
\item \code{rbranding_config.yml}: contains remote and local file paths to brand files
\item \verb{_brand.yml}: a placeholder branding file
It is intended to be run once. Use a \verb{get_brand_*()} function to download/update
the brand file.
}
}
\examples{
tmpdir <- file.path(tempdir(), "brand_files")

brand_init(install_path = tmpdir)

# Clean up
unlink(tmpdir, recursive = TRUE)
}
