% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths.R
\name{silverman_bandwidth}
\alias{silverman_bandwidth}
\title{Silverman's Rule of Thumb for Bandwidth Selection}
\usage{
silverman_bandwidth(X, kernel_type = "normal")
}
\arguments{
\item{X}{A numerical vector of sample data.}

\item{kernel_type}{A string identifying the kernel type.}
}
\value{
A scalar representing the optimal bandwidth.
}
\description{
Implements Silverman's rule of thumb for selecting an optimal bandwidth in kernel density estimation.
}
\examples{
# Generate sample data
X <- rnorm(100)
# Get optimal bandwidth using Silverman's rule
h_opt <- silverman_bandwidth(X, kernel_type = "normal")
}
