% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot_ft}
\alias{plot_ft}
\title{Plot the Fourier Transform}
\usage{
plot_ft(X, xi_interval, ft_plot.resol = 500)
}
\arguments{
\item{X}{A numerical vector of sample data.}

\item{xi_interval}{A list containing the lower (\code{xi_lb}) and upper (\code{xi_ub}) bounds of the xi interval.}

\item{ft_plot.resol}{An integer representing the resolution of the plot, specifically the number of points
used to represent the Fourier transform. Defaults to 500.}
}
\value{
A ggplot object representing the plot of the Fourier transform.
}
\description{
Plot the Fourier Transform of the
}
\details{
C = 1, the parameter in \eqn{O(1/n^{0.25})}, see more details in in Schennach (2020).
}
\examples{
plot_ft(
  sample_data$X,
  xi_interval = list(xi_lb = 1, xi_ub = 50),
  ft_plot.resol = 1000
)
}
