% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-futures.R
\name{code2month}
\alias{code2month}
\title{Convert Maturity Code to Corresponding Month}
\usage{
code2month(x)
}
\arguments{
\item{x}{A character vector with the maturity code(s) of futures contracts.
The codes can be either a single letter (e.g., "F", "G", "H", ...)
representing the new code format or a three-letter abbreviation (e.g.,
"JAN", "FEV", "MAR", ...) representing the old code format.}
}
\value{
A vector of integers corresponding to the months of the year, where
1 = January, 2 = February, ..., 12 = December.
}
\description{
This function takes a character string representing the maturity code of a
futures contract and returns the corresponding month as an integer. It supports
both the new and old maturity code formats used in futures contracts.
}
\details{
The function distinguishes between two maturity code formats:
\itemize{
\item The \strong{new code format} uses a single letter (e.g., "F" = January,
"G" = February, etc.).
\item The \strong{old code format} uses a three-letter abbreviation (e.g.,
"JAN" = January, "FEV" = February, etc.).
}
}
\examples{
code2month(c("F", "G", "H", "J", "K", "M", "N", "Q", "U", "V", "X", "Z"))
code2month(c("JAN", "FEV", "MAR", "NOV", "DEZ"))
}
