% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_normals_mesh.R
\name{smooth_normals_mesh}
\alias{smooth_normals_mesh}
\title{Calculate Smooth Mesh Normals}
\usage{
smooth_normals_mesh(mesh, id = NA)
}
\arguments{
\item{mesh}{The mesh.}

\item{id}{Default \code{NA} (all shapes). The shape index to have new normals calculated.}
}
\value{
Mesh with new vertex normals
}
\description{
Calculate Smooth Mesh Normals
}
\examples{
if(run_documentation()) {
 #Let's construct a mesh from the volcano dataset
 #Build the vertex matrix
  vertex_list = list()
  counter = 1
  for(i in 1:nrow(volcano)) {
    for(j in 1:ncol(volcano)) {
      vertex_list[[counter]] = matrix(c(j,volcano[i,j],i), ncol=3)
      counter = counter + 1
    }
  }
  vertices = do.call(rbind,vertex_list)
  
  #Build the index matrix
  index_list = list()
  counter = 0
  for(i in 1:(nrow(volcano)-1)) {
    for(j in 1:(ncol(volcano)-1)) {
      index_list[[counter+1]] = matrix(c(counter,counter+ncol(volcano),counter+1,
                                         counter+ncol(volcano),counter+ncol(volcano)+1,counter + 1), 
                                       nrow=2, ncol=3, byrow=TRUE)
      counter = counter + 1
    }
    counter = counter + 1
  }
  indices = do.call(rbind,index_list)
  #Construct the mesh
  volc_mesh = construct_mesh(vertices = vertices, indices = indices,
                             material = material_list(type="diffuse", diffuse="darkred", 
                                                      ambient = "darkred", ambient_intensity=0.2))
  #Rasterize the no-normal scene
  scale_mesh(volc_mesh, scale = c(1,1/3,1)) |> 
    center_mesh() |> 
    rasterize_scene(lookfrom=c(-50,50,100),lookat=c(7,-15,0), fov=40,width=800,height=800,
                    light_info = directional_light(c(0,1,1)) |>
                      add_light(directional_light(c(1,1,-1))))
                      
  #Smooth the mesh
  volc_mesh_smooth = smooth_normals_mesh(volc_mesh)
  
  #Rasterize the scene
  scale_mesh(volc_mesh_smooth, scale = c(1,1/3,1)) |> 
    center_mesh() |> 
    rasterize_scene(lookfrom=c(-50,50,100),lookat=c(7,-15,0), fov=40,width=800,height=800,
                    light_info = directional_light(c(0,1,1)) |>
                      add_light(directional_light(c(1,1,-1))))
}
}
