% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_string_dimensions.R
\name{get_string_dimensions}
\alias{get_string_dimensions}
\title{Get String Dimensions}
\usage{
get_string_dimensions(string, font = "sans", size = 12, align = "center", ...)
}
\arguments{
\item{string}{The string to be measured.}

\item{font}{Default \code{"sans"}.}

\item{size}{A numeric value specifying the size of the font in points.}

\item{align}{Default `"left"``. The string alignment.}

\item{...}{Other arguments to pass to `systemfonts::shape_string()``}
}
\value{
A data.frame listing the string dimensions.
}
\description{
Calculates font metrics for a specified font, font size, and style.
}
\details{
The function renders specific characters (\code{"d"} for ascender, \code{"g"} for descender, \code{"x"} for neutral) using the specified font parameters. It calculates the bounding box of each character to determine the necessary adjustments for accurate text positioning.
}
\examples{
# Get height of basic sans font
get_string_dimensions("This is a string", size=24)
}
