% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_image_overlay.R
\name{add_image_overlay}
\alias{add_image_overlay}
\title{Add Overlay (Deprecated)}
\usage{
add_image_overlay(...)
}
\arguments{
\item{...}{to pass to \code{render_image_overlay()} function.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an RGB array/filename and adds an image overlay.
}
\examples{
if(run_documentation()){
#Plot the dragon
plot_image(dragon)
}
if(run_documentation()){
#Add an overlay of a red semi-transparent circle:
circlemat = generate_2d_disk(min(dim(dragon)[1:2]))
circlemat = circlemat/max(circlemat)

#Create RGBA image, with a transparency of 0.5
rgba_array = array(1, dim=c(nrow(circlemat),ncol(circlemat),4))
rgba_array[,,1] = circlemat
rgba_array[,,2] = 0
rgba_array[,,3] = 0
dragon_clipped = dragon
dragon_clipped[dragon_clipped > 1] = 1
add_image_overlay(dragon_clipped, image_overlay = rgba_array,
                 alpha=0.5, preview = TRUE)
}
}
