% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel-lapply_jobs.R
\name{with_rave_parallel}
\alias{with_rave_parallel}
\alias{lapply_jobs}
\title{Internal parallel functions}
\usage{
with_rave_parallel(expr, .workers = 0)

lapply_jobs(
  x,
  fun,
  ...,
  .globals = list(),
  .workers = 0,
  .always = FALSE,
  callback = NULL
)
}
\arguments{
\item{expr}{expression to evaluate with parallel workers}

\item{.workers}{number of workers: note the actual numbers may differ,
depending on the options and number of input elements}

\item{x}{a list, vector, array of R objects}

\item{fun}{function to apply to each element of \code{x}}

\item{...}{additional arguments to be passed to \code{fun}}

\item{.globals}{global variables to be serialized}

\item{.always}{whether always use workers, only considered when number of
workers is one; default is false, then run jobs in the main process when
only one worker is required}

\item{callback}{callback function, input is each element of \code{x} and
should return a string, for progress bar}

\item{workers}{number of workers}
}
\description{
Experimental parallel functions, intended for internal use now. The goal
is to allow 'RAVE' functions to gain the potential benefit from parallel
computing, but allow users to control whether to do it.
}
\details{
By default, \code{lapply_jobs} is almost identical to \code{\link{lapply}}.
It only runs in parallel when running inside of \code{with_rave_parallel}.

The hard max-limit number of workers are determined by the 'RAVE' option
\code{raveio_getopt('max_worker')}. Users can lower this number for
memory-intensive tasks manually, via argument \code{.workers}.
The actual number of workers might be less than the requested ones, this
is often a result of sort input \code{x}. If the number of input iterations
has fewer than the max worker size, then the number of workers automatically
shrinks to the length of input list. All workers will be a child process
running separate from the main session, except for when only one worker
is needed and \code{.always=FALSE}: the only task will be executed in the
main session.

Each worker session will run a completely isolated new process. There is
a ramp-up serialization that is needed for global objects (objects that
are defined elsewhere or outside of the function). Please make sure
the global objects are specified explicitly in \code{.globals}, a named list.
Unlike \code{future} package, users must specify the global objects.

The global objects might be large to serialize. Please optimize the code
to avoid serializing big objects, especially environments or functions.
All objects inheriting \code{\link{RAVESerializable}} class with
\code{@marshal} and \code{@unmarshal} methods implemented correctly will
be serialized with reference hook \code{rave_serialize_refhook}, making
them extremely efficient.
}
\examples{


# Run without `with_rave_parallel`
res <- lapply_jobs(1:5, function(x, ...) {
  c(child = Sys.getpid(), ...)
}, main = Sys.getpid())

simplify2array(res)

# Comparison
f <- function(n = 5, workers = 0) {
  system.time({
    ravepipeline::lapply_jobs(seq_len(n), function(x, ...) {
      Sys.sleep(1)
      c(child = Sys.getpid(), ...)
    }, main = Sys.getpid(), .workers = workers, callback = I)
  })
}

\dontrun{

# Without parallel
f()
#>    user  system elapsed
#>   0.022   0.019   5.010


# with parallel
with_rave_parallel({
  f()
})
#>    user  system elapsed
#>   0.729   0.190   1.460

}

}
