% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize.R
\name{rave-serialize-refhook}
\alias{rave-serialize-refhook}
\alias{rave_serialize_refhook}
\alias{rave_serialize_impl}
\alias{rave_serialize_impl.default}
\alias{rave_serialize_impl.RAVESerializable}
\alias{rave_serialize_impl.rave-brain}
\alias{rave_unserialize_refhook}
\alias{rave_unserialize_impl}
\alias{rave_unserialize_impl.default}
\alias{rave_unserialize_impl.rave_serialized}
\alias{rave_unserialize_impl.rave_serialized_r6}
\alias{rave_unserialize_impl.rave_serialized_rave-brain}
\title{Serialization reference hook generic functions}
\usage{
rave_serialize_refhook(object)

rave_serialize_impl(object)

\method{rave_serialize_impl}{default}(object)

\method{rave_serialize_impl}{RAVESerializable}(object)

\method{rave_serialize_impl}{`rave-brain`}(object)

rave_unserialize_refhook(x)

rave_unserialize_impl(x)

\method{rave_unserialize_impl}{default}(x)

\method{rave_unserialize_impl}{rave_serialized}(x)

\method{rave_unserialize_impl}{rave_serialized_r6}(x)

\method{rave_unserialize_impl}{`rave_serialized_rave-brain`}(x)
}
\arguments{
\item{object}{Object to serialize (environment or external pointers)}

\item{x}{raw or string objects that will be passed to
\code{\link{unserialize}} function before further reconstruction}
}
\value{
\code{rave_serialize_refhook} returns either serialized objects
in string (raw vector converted to char via \code{rawToChar}), or \code{NULL}
indicating the object undergoing default serialization;
\code{rave_unserialize_refhook} returns the reconstructed object.
}
\description{
Serialization reference hook generic functions
}
\examples{

# This example requires additional `filearray` package
# If you are an RAVE user (installed RAVE via rave.wiki)
# then this package was installed

x0 <- array(rnorm(240000), c(200, 300, 4))
x1 <- filearray::as_filearray(x0)
x2 <- RAVEFileArray$new(x1, temporary = TRUE)

r0 <- serialize(x0, NULL, refhook = rave_serialize_refhook)
r1 <- serialize(x1, NULL, refhook = rave_serialize_refhook)
r2 <- serialize(x2, NULL, refhook = rave_serialize_refhook)

# Compare the serialization sizes
c(length(r0), length(r1), length(r2))

y0 <- unserialize(r0, refhook = rave_unserialize_refhook)
y1 <- unserialize(r1, refhook = rave_unserialize_refhook)
y2 <- unserialize(r2, refhook = rave_unserialize_refhook)

all(y0 == x0)
all(y1[] == x0)
all(y2[] == x0)

\dontrun{

# 3D Brain, this example needs RAVE installation, not included in
# this package, needs extra installations available at rave.wiki

# 4 MB
brain <- ravecore::rave_brain("demo/DemoSubject")

# 52 KB
rbrain <- serialize(brain, NULL, refhook = rave_serialize_refhook)

brain2 <- unserialize(rbrain, refhook = rave_unserialize_refhook)

brain2$plot()

}

}
