% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class007-abstract_electrode.R
\name{new_electrode}
\alias{new_electrode}
\alias{new_reference}
\title{Create new electrode channel instance or a reference signal instance}
\usage{
new_electrode(subject, number, signal_type, ...)

new_reference(subject, number, signal_type, ...)

new_electrode(subject, number, signal_type, ...)

new_reference(subject, number, signal_type, ...)
}
\arguments{
\item{subject}{characters, or a \code{\link{RAVESubject}} instance}

\item{number}{integer in \code{new_electrode}, or characters in
\code{new_reference}; see 'Details' and 'Examples'}

\item{signal_type}{signal type of the electrode or reference; can be
automatically inferred, but it is highly recommended to specify a value;
see \code{\link{SIGNAL_TYPES}}}

\item{...}{other parameters passed to class constructors, respectively}
}
\value{
Electrode or reference instances that inherit
\code{\link{RAVEAbstarctElectrode}} class

Electrode or reference instances that inherit
\code{\link{RAVEAbstarctElectrode}} class
}
\description{
Create new electrode channel instance or a reference signal instance

Create new electrode channel instance or a reference signal instance
}
\details{
In \code{new_electrode}, \code{number} should be a positive
valid integer indicating the electrode number. In \code{new_reference},
\code{number} can be one of the followings:
\describe{
\item{\code{'noref'}, or \code{NULL}}{no reference is needed}
\item{\code{'ref_X'}}{where \code{'X'} is a single number, then the
reference is another existing electrode; this could occur in
bipolar-reference cases}
\item{\code{'ref_XXX'}}{\code{'XXX'} is a combination of multiple
electrodes. This
could occur in common average reference, or white matter reference. One
example is \code{'ref_13-16,24'}, meaning the reference signal is an
average of electrode 13, 14, 15, 16, and 24.}
}

In \code{new_electrode}, \code{number} should be a positive
valid integer indicating the electrode number. In \code{new_reference},
\code{number} can be one of the followings:
\describe{
\item{\code{'noref'}, or \code{NULL}}{no reference is needed}
\item{\code{'ref_X'}}{where \code{'X'} is a single number, then the
reference is another existing electrode; this could occur in
bipolar-reference cases}
\item{\code{'ref_XXX'}}{\code{'XXX'} is a combination of multiple
electrodes that can be parsed by \code{\link[dipsaus]{parse_svec}}. This
could occur in common average reference, or white matter reference. One
example is \code{'ref_13-16,24'}, meaning the reference signal is an
average of electrode 13, 14, 15, 16, and 24.}
}
}
\examples{

# Download subject demo/DemoSubject
if( has_rave_subject("demo/DemoSubject") ) {


# Electrode 14 in demo/DemoSubject
subject <- as_rave_subject("demo/DemoSubject")
e <- new_electrode(subject = subject, number = 14, signal_type = "LFP")

# Load CAR reference "ref_13-16,24"
ref <- new_reference(subject = subject, number = "ref_13-16,24",
                     signal_type = "LFP")
e$set_reference(ref)


# Set epoch
e$set_epoch(epoch = 'auditory_onset')

# Set loading window
e$trial_intervals <- list(c(-1, 2))

# Preview
print(e)

# Now epoch power
power <- e$load_data_with_epochs("power")
names(dimnames(power))

# Subset power
power_array <- subset(power, Time ~ Time < 0,
                      Electrode ~ Electrode == 14)

# clear cache on hard disk
e$clear_cache()
ref$clear_cache()

}

# Download subject demo/DemoSubject
if( has_rave_subject("demo/DemoSubject") ) {


# Electrode 14 in demo/DemoSubject
subject <- as_rave_subject("demo/DemoSubject")
e <- new_electrode(subject = subject, number = 14, signal_type = "LFP")

# Load CAR reference "ref_13-16,24"
ref <- new_reference(subject = subject, number = "ref_13-16,24",
                     signal_type = "LFP")
e$set_reference(ref)


# Set epoch
e$set_epoch(epoch = 'auditory_onset')

# Set loading window
e$trial_intervals <- list(c(-1, 2))

# Preview
print(e)

# Now epoch power
power <- e$load_data_with_epochs("power")
names(dimnames(power))

# Subset power
subset(power, Time ~ Time < 0, Electrode ~ Electrode == 14)

# clear cache on hard disk
e$clear_cache()
ref$clear_cache()

}
}
